<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;

class Album extends Model{

	use Afrodien;

	protected $table = 'albums';

	public function Structure(){
		$Locale = \App::getLocale();
		$this['title']         = isset($this['title_'.$Locale]) ? $this['title_'.$Locale] : "";
		$this['description']   = isset($this['description_'.$Locale]) ? $this['description_'.$Locale] : "";
		$this['content']   = isset($this['content_'.$Locale]) ? \base64_decode($this['content_'.$Locale]) : "";
		$this['featuredImage'] = $this->getFeaturedImage();
		$this['thumbnail']     = $this->thumbnail();
		$this['url']           = $this->url();
	}

	public function media(){
		$media = [];
		$images = \DB::table('images_albums_media')->leftJoin('media', 'media.id', '=', 'images_albums_media.media_id')->where('album_id',$this->id)->get();
		foreach($images as $image){
			if(isset($image->name) && !empty($image->name) && \file_exists(storage_path('app/public/images/thumbnail/300/',$image->name.'.webp'))){
				if($image->extension=='mp4'){
					$media[] = $this->video('/storage/images/original/',$image->name);
				}else{
					$media[] = $this->image('/images/thumbnail/300/',$image->name.'.webp');
				}
			}
		}
		return $media;
	}

	public function category(){
		return $this->belongsTo("App\AlbumCategory",'category');
    }

	public function thumbnail($Quality=100){
		if(
			isset($this->featured_image) && !empty($this->featured_image)
			&& \file_exists(storage_path('app/public/images/thumbnail/'.$Quality.'/',$this->featured_image.'.webp'))
		){
			$image = $this->image('/images/thumbnail/'.$Quality.'/',$this->featured_image.'.webp');
		}else{
			$image = $this->getFeaturedImage();
		}
		return $image;
	}


	public function getFeaturedImage(){
		if(isset($this->featured_image) && !empty($this->featured_image) && \file_exists(storage_path('app/public/images/original/'.$this->featured_image))){
			$image = $this->image('/images/original/',$this->featured_image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function url(){
		$category = $this->category()->first();
		return route('frontend.albums.view',['category'=>$category->slug,'slug'=>$this->slug]);
	}

	public function scopeActive($query) {
		return $query->where('status', 'published')->where('title_'.\Config::get('app.locale'), '!=', '');
	}

}
