<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class TrendingCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'trending:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(){

		$items = [];
		$report = \DB::select("
			SELECT
				`category_id` , count(`id`) as `counter`
			from
				`reports`
			where
				DATE(`created_at`) > now() - INTERVAL 7 day
				AND
				`category_id` is not null
			GROUP BY
				`category_id`
				order by `counter` DESC
		");
		foreach ($report as $item) {
			$items[] = $item->category_id;
		}
		$items = \implode(',',$items);
		\App\Config::where('name','app.popular.categories')->update(['value' => $items]);


		$items = [];
		$report = \DB::select("
			SELECT
				`post_id` , count(`id`) as `counter`
			from
				`reports`
			where
				DATE(`created_at`) > now() - INTERVAL 7 day
				AND
				`post_id` is not null
			GROUP BY
				`post_id`
				order by `counter` DESC
		");
		foreach ($report as $item) {
			$items[] = $item->post_id;
		}
		$items = \implode(',',$items);
		\App\Config::where('name','app.popular.posts')->update(['value' => $items]);


		$items = [];
		$report = \DB::select("
			SELECT
				`tag_id` , count(`id`) as `counter`
			from
				`reports`
			where
				DATE(`created_at`) > now() - INTERVAL 7 day
				AND
				`tag_id` is not null
			GROUP BY
				`tag_id`
				order by `counter` DESC
		");
		foreach ($report as $item) {
			$items[] = $item->tag_id;
		}
		$items = \implode(',',$items);
		\App\Config::where('name','app.popular.tags')->update(['value' => $items]);

        return 0;
    }
}
