<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;

class CouponCode extends Model{

	use Afrodien;

	protected $table = 'coupons';

	public function scopeActive($query){
		return $query->where('status', 'published');
	}

	public function thumbnail($Quality=100){
		if(
			isset($this->image) && !empty($this->image)
			&& \file_exists(storage_path('app/public/images/thumbnail/'.$Quality.'/',$this->image.'.webp'))
			&& \is_file(storage_path('app/public/images/thumbnail/'.$Quality.'/',$this->image.'.webp'))
		){
			$image = $this->image('/images/thumbnail/'.$Quality.'/',$this->image.'.webp');
		}else{
			$image = $this->getFeaturedImage();
		}
		return $image;
	}

	public function getFeaturedImage(){
		if(isset($this->image) && !empty($this->image) && \file_exists(storage_path('app/public/images/original/'.$this->image))){
			$image = $this->image('/images/original/',$this->image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function structure(){
		$Locale = \App::getLocale();
		$this['title']         = isset($this['title_'.$Locale]) ? $this['title_'.$Locale] : "";
		$this['featuredImage'] = $this->getFeaturedImage();
		$this['thumbnail']     = $this->thumbnail();
	}


}
