<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;

class CouponStore extends Model
{
	use Afrodien;

	protected $table = 'coupons_stores';

	public function scopeFeatured($query){
		return $query->where('status', 'published')->where('is_featured', '1');
	}

	public function scopeActive($query){
		return $query->where('status', 'published');
	}

	public function thumbnail($Quality=100){
		if(
			isset($this->logo) && !empty($this->logo)
			&& \file_exists(storage_path('app/public/images/thumbnail/'.$Quality.'/',$this->logo.'.webp'))
			&& \is_file(storage_path('app/public/images/thumbnail/'.$Quality.'/',$this->logo.'.webp'))
		){
			$image = $this->image('/images/thumbnail/'.$Quality.'/',$this->logo.'.webp');
		}else{
			$image = $this->getFeaturedImage();
		}
		return $image;
	}

	public function getFeaturedImage(){
		if(isset($this->logo) && !empty($this->logo) && \file_exists(storage_path('app/public/images/original/'.$this->logo))){
			$image = $this->image('/images/original/',$this->logo);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function url(){
		return "aa" ;
	}

	public function structure(){
		$Locale = \App::getLocale();
		$this['title']         = isset($this['title_'.$Locale]) ? $this['title_'.$Locale] : "";
		$this['featuredImage'] = $this->getFeaturedImage();
		$this['thumbnail']     = $this->thumbnail();
		$this['url']           = $this->url();
	}

}
