<?php

namespace App\Helpers;

use App;
use League\Flysystem\Config;
use Illuminate\Http\Request;


class Afrodien{

	static function validate(Request $request,$validation){

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];

		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

        return $request->validate($validation, $validation_msgs);

	}

	static function mainNav(){
		return json_decode(file_get_contents(base_path('resources/views/themes/'.\Config::get('app.theme').'/main-nav.json')), true);
	}

    static function setLocale(){

        $locale = \Request::segment(1);
        $languages = \Config::get('app.languages');

        if (\is_object($languages) && property_exists($languages,$locale)) {

			\Config::set('app.default.clean-uri',substr(\Request::path(),3));
			\Config::set('app.default.clean-url',url(substr(\Request::path(),3)));


			if($languages->$locale->isDefault===1){
				\Config::set('app.canonical',url(substr(\Request::path(),3)));
				\Config::set('app.default.url',url(substr(\Request::path(),3)));
				\Config::set('app.default.uri',substr(\Request::path(),3));
			}else{
				\Config::set('app.canonical',url(\Request::path()));
				\Config::set('app.default.url',url(\Request::path()));
				\Config::set('app.default.uri',\Request::path());
			}

			$languages->$locale->isCurrent = 1;
            App::setLocale($locale);

            return $locale;
        }

		\Config::set('app.default.uri',\Request::path());
		\Config::set('app.default.url',url(\Request::path()));
		\Config::set('app.canonical',url(\Request::path()));
		$locale = App::getLocale();
		$languages->$locale->isCurrent = 1;

        return '/';
    }

	static function getGravatar($email){
	    $hash = md5(strtolower(trim($email)));
	    return "http://www.gravatar.com/avatar/$hash";
	}

}
