<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;


class FormBuilder {

	static function Build($id){
		$form = new \App\VirtualForm();
		$form = $form->where('id',$id)->first();
		$form->fields = \json_decode($form->fields, true);
		echo \Form::open(['route' => 'frontend.virtual-form.submit','id' => 'VirtualForm-'.$id , 'method' => 'post','data-id' => $id]);
		foreach ($form->fields as $field) {
			echo '<div class="form-group">';
			//echo \Form::label($field['name'], $field['label'][\Config::get('app.locale')]);
			if($field['type']=='long_text'){
				echo \Form::textarea($field['name'],'',['class' => 'form-control input-box', 'rows'=>"4", 'placeholder' => $field['label'][\Config::get('app.locale')]]);
			}elseif($field['type']=='email'){
				echo \Form::email($field['name'],'',['class' => 'form-control input-box', 'placeholder' => $field['label'][\Config::get('app.locale')]]);
			}else{
				echo \Form::text($field['name'],'',['class' => 'form-control input-box', 'placeholder' => $field['label'][\Config::get('app.locale')]]);

			}
			echo '</div>';
		}
		echo '<div class="alert-group"></div>';
		echo '<div class="form-group text-right">';
		echo \Form::button(__('Submit!').' <i class="far fa-paper-plane"></i>',['type' => 'submit','class' => 'btn btn-default btn-effect submitVirtualForm']);
		echo '</div>';
		echo \Form::close();
	}

	static function delete($form){
		\Schema::dropIfExists('form_'.$form->id);

		// TODO: delete relation tables & media table if exist

	}

	static function create($form){
        if (Schema::hasTable('form_'.$form->id)) {
            FormBuilder::updateTable($form);
        }else{
            FormBuilder::createTable($form);
        }
	}

	static function createTable($form){
		\Schema::create('form_'.$form->id, function (Blueprint $table) use ($form) {
			$table->engine = 'InnoDB';
			$table->id();
			foreach ($form->fields as $field) {
				FormBuilder::getFieldType($table,'form_'.$form->id,$field,$field['name'],1);
			}
			$table->timestamps();
			$table->softDeletes();
		});
	}

	static function updateTable($form){
		\Schema::table('form_'.$form->id, function (Blueprint $table) use ($form) {
			if (!Schema::hasColumn('form_'.$form->id, 'id')) {
				$table->id();
			}
			foreach ($form->fields as $field) {
				FormBuilder::getFieldType($table,'form_'.$form->id,$field,$field['name'],0);
			}
			if (!Schema::hasColumn('form_'.$form->id, 'created_at')) {
				$table->timestamp('created_at');
			}
			if (!Schema::hasColumn('form_'.$form->id, 'updated_at')) {
				$table->timestamp('updated_at');
			}
			if (!\Schema::hasColumn('form_'.$form->id, 'deleted_at')){
				$table->softDeletes();
			}
		});
	}

    static function getFieldType($table,$table_name,$field,$field_name,$is_new){
        switch ($field['type']) {
			case "number":
				$_field = $table->integer($field_name);
                break;
			case "uuid":
				$_field = $table->uuid($field_name);
                break;
            case "date":
				$_field = $table->date($field_name);
                break;
            case "datetime":
				$_field = $table->dateTime($field_name);
                break;
            case "content":
			 	$_field = $table->longText($field_name);
                break;
            case "long_text":
				$_field = $table->text($field_name);
                break;
            default:
				$_field = $table->string($field_name);
        }

		if($field['is_required']==0){
			$_field = $_field->nullable();
		}

		if ($is_new == 0 && Schema::hasColumn($table_name, $field_name)) {
			$_field = $_field->change();
		}

		return $_field;
    }

}
