<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;


class SystemBuilder {

	static function delete($system){
		\Schema::dropIfExists($system->table);

		// TODO: delete relation tables & media table if exist

	}

	static function create($system){
		SystemBuilder::createPermission($system->slug);
        if (Schema::hasTable($system->table)) {
            SystemBuilder::updateTable($system);
        }else{
            SystemBuilder::createTable($system);
        }
	}

	static function createTable($system){
		\Schema::create($system->table, function (Blueprint $table) use ($system) {
			$table->engine = 'InnoDB';
			$table->id();
			foreach ($system->fields as $field) {
				SystemBuilder::getField($table,$system->table,$field,1);
			}
			$table->timestamps();
			$table->softDeletes();
		});
	}

	static function updateTable($system){
		\Schema::table($system->table, function (Blueprint $table) use ($system) {
			if (!Schema::hasColumn($system->table, $system->key)) {
				$table->id();
			}
			foreach ($system->fields as $field) {
				SystemBuilder::getField($table,$system->table,$field,0);
			}
			if (!Schema::hasColumn($system->table, 'created_at')) {
				$table->timestamp('created_at');
			}
			if (!Schema::hasColumn($system->table, 'updated_at')) {
				$table->timestamp('updated_at');
			}
			if (!\Schema::hasColumn($system->table, 'deleted_at')){
				$table->softDeletes();
			}
		});
	}

	static function getField($table,$table_name,$field,$is_new){
		if($field['type']=="multimedia"){
			SystemBuilder::createMultimediaTable($field['name'].'_'.$table_name);
			SystemBuilder::getFieldType($table,$table_name,$field,$field['name'],$is_new);
		}elseif(isset($field['relation']['type']) && $field['relation']['type']=="many"){
			SystemBuilder::createRelationTable($table_name,$field);
        }else if(isset($field['multi_languages']) && $field['multi_languages']=="1" && $field['has_relation']!=1){
            foreach(\Config::get('app.languages') as $language){
                SystemBuilder::getFieldType($table,$table_name,$field,$field['name']."_".$language->prefix,$is_new);
            }
        }else{
            SystemBuilder::getFieldType($table,$table_name,$field,$field['name'],$is_new);
        }
	}

	static function createMultimediaTable($table_name){
		$key = \Str::singular($table_name).'_id';
		$table_name = $table_name.'_media';
		\Schema::dropIfExists($table_name);
		\Schema::create($table_name, function (Blueprint $table) use ($key) {
			$table->unsignedBigInteger('media_id');
			$table->unsignedBigInteger($key);
			$table->primary([$key,'media_id']);
		});
	}

	static function createKey($slug,$prefix=''){
		$key = explode('_',$slug);
		foreach ($key as $i => $word) {
			$key[$i] = \Str::singular($word);
		}
		return $prefix.implode('_',$key).'_id';
	}

	static function createRelationTable($table_name,$field){

		$key1 = \SystemBuilder::createKey($table_name);
		$key2 = \SystemBuilder::createKey($field['relation']['table']);

		$table_name = $field['name'].'_'.$table_name.'_'.$field['relation']['table'].'_r';

		\Schema::dropIfExists($table_name);
		\Schema::create($table_name, function (Blueprint $table) use ($key1,$key2) {
			$table->unsignedBigInteger($key1);
			$table->unsignedBigInteger($key2);
		});
	}

    static function getFieldType($table,$table_name,$field,$field_name,$is_new){
        switch ($field['type']) {
			case "number":
				$_field = $table->integer($field_name);
                break;
			case "uuid":
				$_field = $table->uuid($field_name);
                break;
            case "date":
				$_field = $table->date($field_name);
                break;
            case "datetime":
				$_field = $table->dateTime($field_name);
                break;
            case "content":
			 	$_field = $table->longText($field_name);
                break;
            case "long_text":
				$_field = $table->text($field_name);
                break;
            default:
				$_field = $table->string($field_name);
        }

		if($field['is_required']==0 || $field['required_once']==1){
			$_field = $_field->nullable();
		}

		if ($is_new == 0 && Schema::hasColumn($table_name, $field_name)) {
			$_field = $_field->change();
		}

		return $_field;
    }

	static function createPermission($slug){
		$permissions = ['view','create','edit','delete'];
		foreach($permissions as $permission){
			$UserPermission = new \App\UserPermission();
			$checkExists = $UserPermission->where('slug', $permission.'-'.$slug)->exists();
			if(!$checkExists){
				$UserPermission->name_en = $permission.'-'.$slug;
				$UserPermission->name_ar = $permission.'-'.$slug;
				$UserPermission->slug    = $permission.'-'.$slug;
				$UserPermission->save();
			}
		}
	}

}
