<?php

namespace App\Helpers;

use App;
use Jenssegers\Agent\Agent;


class Tracker{


	public static function registerVisitor(){
		$agent = new Agent();
		$visitor_data = \Location::get(\Request::ip());
		if($visitor_data){
			$countryName = $visitor_data->countryName;
			$regionName  = $visitor_data->regionName;
			$cityName    = $visitor_data->cityName;
		}
		$Visitor                     = new \App\Visitor();
		$Visitor->ip                 = \Request::ip();
		$Visitor->country            = $countryName ?? '';
		$Visitor->region             = $regionName ?? '';
		$Visitor->city               = $cityName ?? '';
		$Visitor->agent              = \Request::header('user-agent');
		$Visitor->locale             = \Config::get('app.locale');
		$Visitor->browser            = $agent->browser() ?? '';
		$Visitor->browser_version    = $agent->version($Visitor->browser) ?? '';
		$Visitor->languages          = \implode(',',$agent->languages()) ?? '';
		$Visitor->device             = $agent->device() ?? '';
		$Visitor->platform           = $agent->platform() ?? '';
		$Visitor->platform_version   = $agent->version($Visitor->platform) ?? '';
		$Visitor->robot              = $agent->robot() ?? '';
		$Visitor->save();
		\Config::set('visitor.id',$Visitor->id);
		\Cookie::queue(\Cookie::forever('visitor_id', $Visitor->id));
	}

	public static function visitor_id(){
		$visitor_id = \Cookie::get('visitor_id');
		if($visitor_id===null){
			$visitor_id = \Config::get('visitor.id');
		}
		return $visitor_id;
	}


	public static function addToReport($type,$id){
		$visitor_id = \Tracker::visitor_id();

		$fullUrl = \Request::fullUrl();
        $fullUrl = urldecode($fullUrl);
        $locale = \App::getLocale();

		if($type=="search"){
			$field = "`search_term` = ?,";
		}else{
			$field = "`".$type."_id` = ?,";
		}

		\DB::insert("
			INSERT INTO `reports`
			set
			".$field."
			`url` = ?,
			`locale` = ?,
			`visitor_id` = ?,
			`created_at` = ?,
			`updated_at` = ?

		", [$id,$fullUrl,$locale,$visitor_id,date("Y-m-d H:i:s"),date("Y-m-d H:i:s")]);

    }

	public static function addToErrorReport(){
        $fullUrl = \Request::fullUrl();
        $fullUrl = urldecode($fullUrl);
		\DB::insert("INSERT INTO `reports_error_pages` (`url` , `counter`)
			SELECT * FROM (SELECT ? , 0) AS tmp
			WHERE NOT EXISTS (
			    SELECT `url` FROM `reports_error_pages` WHERE `url` = ?
			) LIMIT 1
		", [$fullUrl,$fullUrl]);
		\DB::update("update `reports_error_pages` set `counter`=`counter`+1 WHERE `url` = ? ", [$fullUrl]);
    }

	public static function addToSearchReport(){
		$term = \request('term');
		\DB::insert("INSERT INTO `reports_search` (`term` , `counter`, `created_at`)
			SELECT * FROM (SELECT ? , 0, '".date("Y-m-d H:i:s")."') AS tmp
			WHERE NOT EXISTS (
			    SELECT `term` FROM `reports_search` WHERE `term` = ?
			) LIMIT 1
		", [$term,$term]);
		\DB::update("update `reports_search` set `counter`=`counter`+1 , `updated_at` = ? WHERE `term` = ? ", [date("Y-m-d H:i:s"),$term]);
    }

}
