<?php

namespace App\Helpers;
use Request;
use App\UserActivity as UserActivityModel;


class UserActivity{

    public static function addToLog($subject){
        $log = [];
        $log['body'] = $subject;
        $log['url'] = Request::fullUrl();
        $log['method'] = Request::method();
        $log['ip'] = Request::ip();
        $log['agent'] = Request::header('user-agent');
        $log['user_id'] = auth()->check() ? auth()->user()->id : 1;
        UserActivityModel::create($log);
    }

	public static function userActivityLists($user_id=''){
		if(empty($user_id)){
			return UserActivityModel::latest()->get();
		}
		return UserActivityModel::latest()->where('user_id', '=', $user_id)->limit(20)->get();
    }


	public static function list($limit=10){
		return UserActivityModel::select('users.name','users_activities.body','users_activities.created_at')->join('users', 'users.id', '=', 'users_activities.user_id')->latest('users_activities.created_at')->limit($limit)->get();
    }


}
