<?php

namespace App\Helpers;

use Illuminate\Http\Request;

class VirtualSystem {

	static function setValidation($field,$status='store',$VirtualSystem,$item=''){

		$_validation = [];

		if ($field['is_required'] == "1") {
			$_validation[] = 'required';
		}

		if ($field['type'] == "multimedia") {
			$_validation[] = 'array';
		}

		if ($field['type'] == "email") {
			$_validation[] = 'email';
		}

		if ($field['type'] == "options") {
			$options = [];
			foreach($field['values'] as $option){
				$options[] = $option['name'];
			}
			$_validation[] = 'in:'.implode(',',$options);
		}

		if ($field['unique'] == "1" && $status == 'store') {
			$_validation[] = 'unique:' . $VirtualSystem->table;
		}


		if ($field['unique'] == "1" && $status == 'update') {
			$PK = $VirtualSystem->key;
			if($field['multi_languages']==1){
				foreach (\Config::get('app.languages') as $language) {
					$_validation[] = 'unique:' . $VirtualSystem->table.','.$field['name'].'_'.$language->prefix.','.$item->$PK.','.$VirtualSystem->key;
				}
			}else{
				$_validation[] = 'unique:' . $VirtualSystem->table.','.$field['name'].','.$item->$PK.','.$VirtualSystem->key;
			}
		}

		$_validation = implode("|", $_validation);

		return $_validation;
	}


	static function initialDatatable(Request $request){
		$data = [];
		$data['data'] = [];
        $data['recordsTotal'] = 0;
        $data['recordsFiltered'] = 0;
        $data['length'] = $request->length;
        if($data['length']=="-1"){
            $data['length'] = 1000000;
        }
        $data['start']   = $request->start;
        $data['search']  = $request->search;
        $data['columns'] = $request->columns;
        $data['order']   = $request->order;
		return $data;
	}

	static function getOperations($system_slug,$operations,$record_id){
		$_operations = '';
		if(in_array("edit",$operations) && (  \Gate::check('edit-'.$system_slug) || \Gate::check('root-access') ) ){
			$_operations .= '
				<a class="btn btn-info btn-sm" href="'.route('dashboard.virtual-system.edit',['page_slug'=>$system_slug,'record_id'=>$record_id]).'">
					<i class="fas fa-pencil-alt"></i>
				</a>
			';
		}
		if(in_array("delete",$operations) && (  \Gate::check('delete-'.$system_slug) || \Gate::check('root-access') ) ){
			$_operations .= '
				<button class="btn btn-danger btn-sm delete_record" type="button" data-id="'.$record_id.'" data-toggle="modal" data-target="#delete_modal">
					<i class="fas fa-trash"></i>
				</button>
			';
		}
		return $_operations;
	}



}
