<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\ResetsPasswords;
use App\Traits\Afrodien;


class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords,Afrodien;

    /**
     * Where to redirect users after resetting their password.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    public $data = [];

    public function __construct(){
		$this->prepareViewer();
    }

	public function showResetForm(\Request $request, $token = null){
		$this->data['page']  = \App\Page::where('slug', '=', 'reset')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->data['token'] = $token;
		$this->data['email'] = \request('email');
		$this->getMeta();
	    return view('themes.'.\Config::get('app.theme').'.pages.restore',$this->data);
	}
}
