<?php

namespace App\Http\Controllers\Customer;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Validator;
use Str;
use App\Traits\Afrodien;

class SurveyController extends Controller{

	use Afrodien;

	public function __construct(){
		$this->prepareViewer();
    }

    public function index(){
		$roles = \Auth::user()->roles;
		$Surveys = [];
		foreach ($roles as $role) {
			foreach ($role->surveys as $survey) {
				$Surveys[$survey['id']] = $survey;
			}
		}
        return view('customer.pages.surveys.index')->withSurveys($Surveys);
    }

    public function submit($id){
		$data = [];

		$user = Auth::user();

		$validation = [];
		$validation['submission'] = "required|array";

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];

		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

		$survey = new \App\Survey();
		$survey = $survey->find($id);
		$submission = \DB::table('surveys_submission')->where('user_id',$user->id)->where('survey_id',$id)->first();
		if($submission){
			$validation_msgs = [
				'uniqueSubmission.required' => __('You have submitted this survey.')
			];
			$validation['uniqueSubmission']   = "required";
		}

		$data = $this->validate(request(), $validation, $validation_msgs);




		\DB::table('surveys_submission')->insert([
			[
				'submission' => \json_encode($data['submission']),
				'user_id'    => $user->id,
				'completed'  => 1,
				'survey_id'  => $id
			]
		]);




		\UserActivity::addToLog('submited survey id:'.$id);

		$data['success'] = true;
		$data['message'] = $survey->successfully_message;

		return $data;
	}

    public function view($id){


		$user = \Auth::user();


		$roles = $user->roles;


		$submission = \DB::table('surveys_submission')->where('user_id',$user->id)->where('survey_id',$id)->first();
		if($submission){
			$submission->submission = \json_decode($submission->submission,'true');
		}

		$Surveys = [];
		foreach ($roles as $role) {
			foreach ($role->surveys as $survey) {
				$Surveys[$survey['id']] = $survey;
			}
		}
		$Survey = \App\Survey::where('id',$id)->with('domains')->firstOrFail();
		if(array_key_exists($id,$Surveys) && $Survey){
		    return view('customer.pages.surveys.view')->withSurvey($Survey)->withSubmission($submission);
		}

    }

}
