<?php

namespace App\Http\Controllers\Customer;

use App\SupportTicket;
use App\SupportTicketMessage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Validator;
use Str;
use App\Traits\Afrodien;

class TicketController extends Controller{

	use Afrodien;

	public function __construct(){
		$this->prepareViewer();
    }

    public function index(){
        $tickets = SupportTicket::where('user_id', Auth::id())->get();
        return view('customer.pages.tickets.index')->withTickets($tickets);
    }

    public function view($id){
        $ticket = SupportTicket::where('ticket_uuid', $id)->where('user_id',\auth()->id())->first();
        if($ticket){
            $messages = SupportTicketMessage::where('ticket_uuid', $id)->orderBy('id', 'desc')->take(5)->get();
            return view('customer.pages.tickets.view')->withTicket($ticket)->withMessages($messages);
        }

    }

    public function reply(Request $request){

        //TODO :: Security Here To check If Have This Ticket By User Id

		$validation = [];
		$validation['message']   = "required";
		$validation['ticket_uuid'] = "required";

		$validation_msgs = [];
		$validation_msgs['demo.required'] = __('Sorry, demo mode is enabled');

		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}


		$ticket = \App\SupportTicket::where('ticket_uuid',\request('ticket_uuid'))->where('user_id',Auth::id())->where('status','!=','closed')->firstOrFail();
		if($ticket){
			$ticket->status      = 'awaiting';
			$ticket->update();
		}

		$inputs = $this->validate(request(), $validation,$validation_msgs);

        $message = new SupportTicketMessage();
		$message->created_by   = Auth::id();
		$message->ticket_uuid = $inputs['ticket_uuid'];
		$message->message     = $inputs['message'];
		$message->save();

        return redirect()->back();
    }

    public function create(){
        return view('customer.pages.tickets.create');
    }

    public function store(Request $request)
    {
        $valid = Validator::make($request->all(), [
            'title' => 'required',
            'department' => 'required',
            'description' => 'required'
        ]);

        if ($valid->passes()) {
            $ticket = SupportTicket::create([
                'user_id' => \auth()->id(),
                'created_by' => \auth()->id(),
                'title' => $request->post('title'),
                'department_id' => $request->post('department'),
                'ticket_uuid' => Str::uuid(),
                'status' => 'awaiting'
            ]);

			$message = new \App\SupportTicketMessage();
			$message->ticket_uuid = $ticket->ticket_uuid;
			$message->message     = $request->post('description');
			$message->created_by   = \Auth::user()->id;
			$message->save();

        }
        return redirect()->route('customer.tickets.index');
    }

    public function close($uuid)
    {
        $ticket = SupportTicket::where('ticket_uuid', $uuid)->first();
        if ($ticket->user_id == \auth()->id()) {
            $ticket->status = "closed";
            $ticket->save();
            return redirect()->route('customer.tickets.index');
        }

    }

    public function reporting($uuid,$id){
        $message = SupportTicketMessage::where('ticket_uuid',$uuid)->where('id',$id)->first();
        $ticket = SupportTicket::where('ticket_uuid',$uuid)->first();
        if($ticket->user_id == \auth()->id()){
            return view('customer.pages.tickets.report')->withMessage($message)->withTicket($ticket);
        }else{
            return abort('403');
        }
    }

    public function submitReporting(Request $request,$uuid,$id){
        $message = SupportTicketMessage::where('ticket_uuid',$uuid)->where('id',$id)->first();
        $ticket = SupportTicket::where('ticket_uuid',$uuid)->first();
        if($ticket->user_id == \auth()->id()){
            $message->note=$request->note;
            $message->save();
            return redirect()->route('customer.tickets.index');
        }else{
            return abort('403');
        }
    }

	public function rating(Request $request,$uuid){
        if ($request->rating > 0 and $request->rate <=5){
            $ticket = SupportTicket::where('ticket_uuid',$uuid)->first();
            if($ticket->user_id==auth()->id() and empty($ticket->rate)){
                $ticket->rate=$request->rating;
                $ticket->notes=$request->notes;
                $ticket->save();
                return redirect()->back();
            }else{
                return abort(403);
            }
        }else{
            return abort(500);
        }
    }
}
