<?php


namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


class DashboardController extends Controller
{
	/**
	 * Create a new controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		$this->middleware('auth');
	}

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){

        $title = __('Home');


		$rows = \DB::select("
			SELECT
				DATE(`created_at`)  as `date`,
				count( `id` ) AS `counter`
			FROM
				`visitors`
			WHERE
				DATE(`created_at`)  > DATE(NOW()) - INTERVAL 14 DAY
				and `robot`='0'
			GROUP BY
				DATE(`created_at`)
			order by
				DATE(`created_at`) desc
		");

		$rows_count = count($rows);
		$dayOfWeek = [];
		$list1 = [];
		$list2 = [];

		if($rows_count==14){
			for($i=0;$i<7;$i++){
				$dayOfWeek[] = __(date("l", strtotime($rows[$i]->date)));
				$list1[] = $rows[$i]->counter;
				$list2[] = $rows[$i+7]->counter;
			}
		}elseif($rows_count<=7){
			for($i=0;$i<$rows_count;$i++){
				$dayOfWeek[] = __(date("l", strtotime($rows[$i]->date)));
				$list1[] = $rows[$i]->counter;
				$list2[] = 0;
			}
		}elseif($rows_count>7){
			for($i=0;$i<7;$i++){
				$dayOfWeek[] = __(date("l", strtotime($rows[$i]->date)));
				$list1[] = $rows[$i]->counter;
				$list2[] = isset($rows[$i+7]) ? $rows[$i+7]->counter : 0;
			}
		}


		$week1 = \DB::select("
			select sum(`counter`) as `sum` from (
				SELECT
					DATE(`created_at`)  as `date`,
					count( `id` ) AS `counter`
				FROM
					`visitors`
				WHERE
					DATE(`created_at`)  > DATE(NOW()) - INTERVAL 7 DAY
					and `robot`='0'
				GROUP BY
					DATE(`created_at`)
				order by
					DATE(`created_at`) desc

			) as tmp2
		");
		$week2 = \DB::select("
			select sum(`counter`) as `sum` from (
				SELECT
					DATE(`created_at`)  as `date`,
					count( `id` ) AS `counter`
				FROM
					`visitors`
				WHERE
					DATE(`created_at`)  > DATE(NOW()) - INTERVAL 14 DAY
					and `robot`='0'
					and
					DATE(`created_at`)  <= DATE(NOW()) - INTERVAL 7 DAY
				GROUP BY
					DATE(`created_at`)
				order by
					DATE(`created_at`) desc
			) as tmp
		");

		$week1[0]->sum = ($week1[0]->sum==0) ? 1 : $week1[0]->sum;
		$week2[0]->sum = ($week2[0]->sum==0) ? 1 : $week2[0]->sum;
		$percentage = round((  1 - ($week2[0]->sum / $week1[0]->sum) ) * 100);

        $data = [
            'title'      => $title,
            'percentage' => $percentage,
            'dayOfWeek'  => json_encode(\array_reverse($dayOfWeek)),
            'list1'      => json_encode(\array_reverse($list1)),
            'list2'      => json_encode(\array_reverse($list2))
        ];


		return view('dashboard.pages.index',$data);

        $user = \App\User::find(1);
        $details = [
            'greeting' => 'Hi Artisan',
            'body' => 'This is our example notification tutorial',
            'thanks' => 'Thank you for visiting codechief.org!',
        ];
        $n = new \App\Notifications\UserNotification;
        $n->set_details($details);
        $user->notify($n);

    }






    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
