<?php

namespace App\Http\Controllers\Dashboard\Developers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SystemBuilderController extends Controller{

    public $database = [];

	public function listTableField(){
        $data = [];
        $columns = \DB::select("SHOW COLUMNS FROM `". \request('table') ."` like '%".\request('search')."%'  ");
        foreach ($columns as $column){
            $row = [];
            $row['id'] = $column->Field;
            $row['text'] = $column->Field;
            $data['results'][] = $row;
        }
        return $data;
    }

    public function index(){
        $data = [];
        $data['title'] = __('Virtual System');
        $data['data'] = \App\VirtualSystem::all();
        return view('dashboard.pages.system-builder.index', $data);
    }

    public function delete(Request $request){
        $data = [];

        $validation = [
            'record_id' => 'required',
        ];

		$inputs = \Afrodien::validate($request,$validation);

        $VirtualSystem = \App\VirtualSystem::find($inputs['record_id']);
        if($VirtualSystem){
			\SystemBuilder::delete($VirtualSystem);
            $VirtualSystem->forceDelete();
            $data['success'] = true;
            $data['message'] = 'record deleted';
			\UserActivity::addToLog('deleted Virtual System #'.$inputs['record_id'].' name: '.$VirtualSystem->slug);
        }else{
            $data['success'] = false;
            $data['message'] = "record id or system slug is invalid";
        }


        return $data;
    }

    public function edit(){
        $data = [];
        $data['title'] = __('Edit Virtual System');
        $data['system'] = \request('system_id');
        $data['system']->fields = json_decode($data['system']->fields,true);
        return view('dashboard.pages.system-builder.form', $data);
    }

    public function create(){
        $data = [];
        $data['title'] = __('New Virtual System');
        return view('dashboard.pages.system-builder.form', $data);
    }

    public function update(Request $request){
        $data = [];

		$VirtualSystem = \request('system_id');

	    $validation = [
            'system_name' => [
                'required',
                'unique:virtual_systems,slug,'.$VirtualSystem->id,
                'regex:/^[a-zA-Z-_]+$/'
            ],
            'notes' => 'required',
            'system_fields' => 'required|array',
            'operations' => 'required|array',
        ];

		foreach(\Config::get('app.languages') as $language){
			$prefix = $language->prefix;
			$validation['title_'.$prefix] = 'required';
		}

		$inputs = \Afrodien::validate($request,$validation);

        $fields      = $inputs['system_fields'];
        $system_slug = \Str::slug($inputs['system_name'], '-');
        $table_name  = \Str::slug($inputs['system_name'], '_');

		foreach(\Config::get('app.languages') as $language){
			$title_prefix = 'title_'.$language->prefix;
			$VirtualSystem->$title_prefix = $inputs[$title_prefix];
		}

		$VirtualSystem->key        = 'id';
		$VirtualSystem->notes      = $inputs['notes'];
        $VirtualSystem->fields     = json_encode($fields);
        $VirtualSystem->slug       = $system_slug;
        $VirtualSystem->table      = $table_name;
        $VirtualSystem->operations = implode(',',$inputs['operations']);
        $VirtualSystem->update();

		$VirtualSystem->fields = $fields;

		\SystemBuilder::create($VirtualSystem);

		\UserActivity::addToLog('updated Virtual System #'.$VirtualSystem->id.' name: '.$VirtualSystem->slug);

        $data['success'] = true;
        $data['message'] = 'system updated successfully.';

        return json_encode($data);
    }

    public function store(Request $request){
        $data = [];
        $validation = [
            'system_name' => [
                'required',
                'unique:virtual_systems,slug',
                'regex:/^[a-zA-Z-_]+$/'
            ],
            'notes' => 'required',
            'system_fields' => 'required|array',
            'operations' => 'required|array',
        ];

		foreach(\Config::get('app.languages') as $language){
			$prefix = $language->prefix;
			$validation['title_'.$prefix] = 'required';
		}

		$inputs = \Afrodien::validate($request,$validation);

        $fields      = $inputs['system_fields'];
        $system_slug = \Str::slug($inputs['system_name'], '-');
        $table_name  = \Str::slug($inputs['system_name'], '_');

        $VirtualSystem = new \App\VirtualSystem();

		foreach(\Config::get('app.languages') as $language){
			$title_prefix = 'title_'.$language->prefix;
			$VirtualSystem->$title_prefix = $inputs[$title_prefix];
		}

        $VirtualSystem->key        = 'id';
        $VirtualSystem->slug       = $system_slug;
        $VirtualSystem->table      = $table_name;
		$VirtualSystem->notes      = $inputs['notes'];
        $VirtualSystem->fields     = json_encode($fields);
        $VirtualSystem->operations = implode(',',$inputs['operations']);
        $VirtualSystem->save();

		$VirtualSystem->fields = $fields;

		\SystemBuilder::create($VirtualSystem);

        $data['success'] = true;
        $data['message'] = 'system created successfully.';

		\UserActivity::addToLog('added new Virtual System #'.$VirtualSystem->id.' - name : '.$VirtualSystem->slug);

        return json_encode($data);
    }

}
