<?php


namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class LanguageController extends Controller{

    public function index(){
		$data = [];
		$data['title'] = __('Languages');
		return view('dashboard.pages.languages.index',$data);
    }

	public function update(){
		$data = [];
		$validation = [];


		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];

		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

		$this->validate(request(), $validation,$validation_msgs);

		foreach(\Config::get('app.languages') as $language){
			$text = \request($language->prefix);
			$text = \json_encode($text);
			file_put_contents("../resources/lang/".$language->prefix.".json",$text);
		}

		\UserActivity::addToLog('Updated website language.');

		$data['success'] = true;
		$data['message'] = 'website language updated';

        return $data;
	}

	public function store(){
		$data = [];
		$validation = [];
		$validation['key'] = "required";

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];

		if(\Config::get('app.demo')==1){
			$validation['demo']   = "required";
		}

		$this->validate(request(), $validation,$validation_msgs);


		$key = \request('key');
		foreach(\Config::get('app.languages') as $language){
			$text = file_get_contents("../resources/lang/".$language->prefix.".json");
			$text = \json_decode($text,true);
			$text[$key] = \request($language->prefix);
			$text[$key] = $text[$key]['value'];
			$text = \json_encode($text);
			file_put_contents("../resources/lang/".$language->prefix.".json",$text);
		}

		\UserActivity::addToLog('added new item to website language.');

		$data['success'] = true;
		$data['message'] = 'website language updated';

        return $data;
	}
}
