<?php


namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use App\User;

class ProfileController extends Controller{

    protected $fillable = ['name', 'email'];

    public function index(){
        $user = Auth::user();
        $logs = \UserActivity::userActivityLists($user->id);
        return view('dashboard.pages.profile.index', ['user' => $user , 'logs' => $logs ,'title' => __('My Profile')]);
    }

    public function edit(){
        $user = Auth::user();
        return view('dashboard.pages.profile.edit', ['user' => $user , 'title' => __('Edit Profile')]);
    }

    public function update(){
		$data = [];

        $user = Auth::user();

		$fields = [
            'name' => 'required',
            'avatar' => 'required',
            'location' => 'required',
            'about' => 'required',
            'job_title' => 'required',
            'email' => 'unique:users,email,'.$user->id.'|email|required',
            'password' =>  [
                'required', function ($attribute, $value, $fail) {
                    if (!\Hash::check($value, $user->password)) {
                        $fail('Your Password is wrong');
                    }
                },
            ],
        ];

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$fields['demo']   = "required";
		}

        $data = $this->validate(request(), $fields, $validation_msgs);
        $data = request()->except(['password']);
        $user->update($data);
        \UserActivity::addToLog('Updated his profile.');

		$data['success'] = true;
		$data['message'] = 'Profile has been updated!';

		return $data;

    }

    public function changePpassword(){
        $user = Auth::user();
        return view('dashboard.pages.profile.change-password', ['title' => __('Change Password')]);
    }

    public function updatePassword(){
		$data = [];
		$fields = [
            'new_password' => 'required|min:8|different:password',
            'confirm_password' =>  'required|same:new_password',
            'password' =>  [
                'required', function ($attribute, $value, $fail) {
                    if (!\Hash::check($value, Auth::user()->password)) {
                        $fail('Your Password is wrong');
                    }
                },
            ],
        ];

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$fields['demo']   = "required";
		}

        $data = $this->validate(request(), $fields, $validation_msgs);
        $user = Auth::user();
        $user->update([
            'password'=>bcrypt(request('new_password'))
        ]);
        \UserActivity::addToLog('changed his password.');

		$data['success'] = true;
		$data['message'] = 'Password has been updated!';

		return $data;

    }

}
