<?php


namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PushNotificationController extends Controller
{

	public function index(){
        $data = [];
        $data['title'] = __('Push Notifications');
        return view('dashboard.pages.push-notification.index', $data);
    }

	public function send(){
		$data = [];
		$fields = [
			'to'           => 'required',
			'title'        => 'required',
			'body'         => 'required',
			'image'        => '',
			'icon'         => '',
			'click_action' => 'required',
		];


		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$fields['demo']   = "required";
		}

		$inputs = $this->validate(request(), $fields, $validation_msgs);

		try {

			$firebase = new \Firebase();

			$receiver_ids = [];
		    if($inputs['to']=="all_subscribers"){

		    }elseif($inputs['to']=="all_users"){
		        $_Tokens = \DB::select(" Select * from `notifications_subscribers` WHERE `user_id` != '' and `user_id` IS NOT NULL and `user_id` != '0' ");
				foreach ($_Tokens as $_Token) {
					$receiver_ids[] = $_Token->token;
		        }
		    }elseif(is_numeric($inputs['to'])){
		        $_Tokens = \DB::select(" Select * from `notifications_subscribers` WHERE `user_id`='".$inputs['to']."' ");
				foreach ($_Tokens as $_Token) {
					$receiver_ids[] = $_Token->token;
		        }
		    }
			$firebase->setPayload($inputs);
			$response = $firebase->send($receiver_ids);
			return response()->json( [
				'response' => $response
			]);

		} catch ( \Exception $ex ) {
			return response()->json( [
				'error'   => true,
				'message' => $ex->getMessage()
			]);
		}


		return $data;
	}

	public function UpdateFcmKey(){
		$data = [];
		$fields = ['FCM_Key' => 'required'];

		$validation_msgs = [
			'demo.required' => __('Sorry, demo mode is enabled')
		];
		if(\Config::get('app.demo')==1){
			$fields['demo']   = "required";
		}

		$inputs = $this->validate(request(), $fields,$validation_msgs);


		\App\Config::where('name','app.fcm.key')->update(['value' => $inputs['FCM_Key']]);
		\UserActivity::addToLog('Updated Fcm Key.');

		$data['success'] = true;
		$data['message'] = 'Fcm Key updated';
		return $data;
	}


}
