<?php

namespace App\Http\Controllers\Dashboard\Tools;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


class VirtualFormController extends Controller{


	public $validation = [];
	public $relations = [];
	public $multimedia = [];
	public $data = [];

	public function index(Request $request){
        $this->data['title'] = __('Forms');
        $this->data['forms'] = \App\VirtualForm::get();
        return view('dashboard.pages.tools.index',$this->data);
    }

	public function view(Request $request,$form,$record_id){
		$this->data['title'] = $form['name_'.\Config::get('app.locale')];
		$form->fields = json_decode($form->fields,true);
		$this->data['form'] = $form;
		$this->data['record'] = \DB::table('form_'.$form->id)->where('id',$record_id)->first();
        return view('dashboard.pages.tools.view',$this->data);
    }


    public function list(Request $request, $form){
		$this->data['title'] = $form['name_'.\Config::get('app.locale')];
		$form->fields = json_decode($form->fields,true);
		$this->data['form'] = $form;
		return view('dashboard.pages.tools.list',$this->data);
	}


    public function data(Request $request, $form){

        $data = \VirtualSystem::initialDatatable($request);

        if($form){

			$form['fields'] = json_decode($form['fields'],true);

			$query = \DB::table('form_'.$form->id);
			$values = [];
			$relations = [];
			$_fields = [];
			$SelectFields = [];
			foreach($form['fields'] as $field){
				if($field['type']=="options"){
					$_fields[] = $field['name'];
					$values[$field['name']] = $field['values'];
				}else{
					$_fields[] = $field['name'];
				}
			}
			$SelectFields[] = 'form_'.$form->id.'.*';
			$query->select($SelectFields);

			$filtered = clone $query;

			if($request->get('order')[0]['column']==0){
				$filtered->orderBy('form_'.$form->id.'.'.'id',$request->get('order')[0]['dir']);
			}
			if(!empty($request->get('columns')[0]['search']['value'])){
				$filtered->orWhere('form_'.$form->id.'.'.'id','like','%'.$request->get('columns')[0]['search']['value'].'%');
			}

			foreach($_fields as $i => $field){

				$_field = 'form_'.$form->id.'.'.$field;

				if(!empty($request->get('columns')[$i+1]['search']['value'])){
					$filtered->orWhere($_field,'like','%'.$request->get('columns')[$i+1]['search']['value'].'%');
				}
				if(!empty($request->get('search')['value'])){
					$filtered->orWhere($_field,'like','%'.$request->get('search')['value'].'%');
				}
				if($request->get('order')[0]['column']==$i+1){
					$filtered->orderBy($_field,$request->get('order')[0]['dir']);
				}
			}

			$totalfiltered = clone $filtered;

			$rows = $filtered->skip($data['start'])->take($data['length'])->get();

			$data['recordsTotal'] = $query->count();
	        $data['recordsFiltered'] = $totalfiltered->count();

			foreach($rows as $row){
				$_row = [];

				$_row[] = $row->id;

				foreach($_fields as $field){
					if(isset($values[$field])){
						$_row[] = isset($values[$field][$row->$field]) ? $values[$field][$row->$field]['label'][\Config::get('app.locale')] : '';
					}else{
						$_row[] = $row->$field;
					}
				}

				$_row[] ='

					<a class="btn btn-info btn-sm" href="'.route('dashboard.tools.forms.view',['form_id'=> $form->id ,'record_id'=>$row->id]).'">
						<i class="fas fa-eye"></i>
					</a>

					<button class="btn btn-danger btn-sm delete_record" type="button" data-id="'.$row->id.'" data-toggle="modal" data-target="#delete_modal">
						<i class="fas fa-trash"></i>
					</button>

				';

				$data['data'][] =  $_row;
			}

        }else{
			$data['error'] = "system name is not exist.";
		}

        return json_encode($data);
    }

    public function store(Request $request, $type){
        $this->data = [];
        $this->validation = [];

        $VirtualSystem = VirtualSystem::where('slug','=',$request->page_slug)->first();
		if($VirtualSystem){
			$VirtualSystem->fields = json_decode($VirtualSystem->fields,true);

			$item = new \App\DynamicModel;
			$item->setSystem($VirtualSystem);

			$this->relations = [];
			$this->multimedia = [];

			$this->setFields($VirtualSystem,$item,'store');

			$inputs = \Afrodien::validate($request,$this->validation);

			$item->save();

			$this->setMultimedia($this->multimedia,$VirtualSystem,$item);
			$this->setRelations($this->relations,$VirtualSystem,$item);

			\UserActivity::addToLog('Added new record #'.$item->id.' at '.$VirtualSystem->table);

			$this->data['message'] = __("record inserted successfully");
			$this->data['success'] = true;

		}else{
			$this->data['success'] = false;
			$this->data['message'] = __("Error, system not found.");
		}

        return $this->data;
    }

    public function update(Request $request){
		$this->data = [];

		$VirtualSystem = VirtualSystem::where('slug','=',$request->page_slug)->first();
		if($VirtualSystem){

			$VirtualSystem->fields = json_decode($VirtualSystem->fields,true);

			$item = new \App\DynamicModel;
			$item->setSystem($VirtualSystem);

			$item = $item->where($VirtualSystem->key,$request->record_id)->firstOrFail();

			$this->relations = [];
			$this->multimedia = [];

			$this->setFields($VirtualSystem,$item,'update');

			$inputs = \Afrodien::validate($request,$this->validation);

			$item->update();

			$this->setMultimedia($this->multimedia,$VirtualSystem,$item);
			$this->setRelations($this->relations,$VirtualSystem,$item);

			\UserActivity::addToLog('updated record #'.$item->id.' at '.$VirtualSystem->table);

			$this->data['message'] = __("record updated successfully");
			$this->data['success'] = true;

		}else{
			$this->data['success'] = false;
			$this->data['message'] = __("Error, system not found.");
		}

        return $this->data;
    }

    public function delete(Request $request, $form){
        $data = [];
        $validation = [
			'record_id' => 'required'
		];

		$inputs = \Afrodien::validate($request,$validation);

		$result = \DB::table('form_'.$form->id)->delete($inputs['record_id']);

		if($result>0){
			\UserActivity::addToLog('deleted record #'.$inputs['record_id'].' at '.$form['name_'.\Config::get('app.locale')]);
	        $data['success'] = true;
	        $data['message'] = __('record deleted successfully');
		}else{
			$data['success'] = false;
			$data['message'] = __('record not exist');
		}
        return $data;
    }

    public function basedOn(Request $request){
		$data = [];

		$validation = [
			'table' => 'required',
			'where' => 'required',
			'by' => 'required',
			'value' => 'required'
		];

		$inputs = \Afrodien::validate($request,$validation);

		$columns = \DB::select("select * from `".$inputs['table']."` where `".$inputs['where']."` = '".$inputs['value']."' and `".$inputs['by']."` like '%".\request('search')."%'  ");
		foreach ($columns as $column){
			$row = [];
			$field_name = $inputs['by'];
			$row['id'] = $column->id;
			$row['text'] = $column->$field_name;
			$data['results'][] = $row;
		}
		return $data;
	}

    public function edit(Request $request){
        $data = [];

        $data['system'] = VirtualSystem::where('slug','=',$request->page_slug)->firstOrFail();
		$data['title'] = $data['system']['title_'.\Config::get('app.locale')];
        $data['system']->fields = json_decode($data['system']->fields,true);

		$item = new \App\DynamicModel;
		$item->setSystem($data['system']);
		$data['record'] = $item->where($data['system']->key,$request->record_id)->firstOrFail();
        return view('dashboard.pages.virtual-system.form', $data);
    }

    public function create(Request $request){
        $data = [];
        $data['system'] = VirtualSystem::where('slug','=',$request->page_slug)->firstOrFail();
        $data['system']->fields = json_decode($data['system']->fields,true);
        $data['title'] = $data['system']['title_'.\Config::get('app.locale')];
        return view('dashboard.pages.virtual-system.form', $data);
    }

}
