<?php

namespace App\Http\Controllers\FrontEnd;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\Afrodien;

class GalleryController extends Controller{

	use Afrodien;

	public function __construct(){
		$this->prepareViewer();
    }

	public function viewCategory(Request $request,$slug){
		$this->data['gallery'] = \App\AlbumCategory::where('slug', '=', $slug)->firstOrFail();
		$this->data['gallery']->structure();
		$this->data['title']  = $this->data['gallery']['title'];
		$this->data['albums'] = $this->data['gallery']->albums()->with('category')->get();
		$this->data['albums']->each(function($album){
			$album->structure();
		});
		$this->getMeta();
		return view('themes.'.\Config::get('app.theme').'.pages.albums',$this->data);
	}

	public function view($category,$slug){
		$this->data['gallery'] = \App\Album::where('slug', '=', $slug)->firstOrFail();
		$this->data['gallery']->structure();
		$this->data['title'] = $this->data['gallery']['title'];
		$this->data['gallery']['media'] = $this->data['gallery']->media();
		$this->getMeta();
		return view('themes.'.\Config::get('app.theme').'.pages.gallery',$this->data);
	}

	public function index(){

		$this->data['page'] = \App\Page::where('slug', '=', 'gallery')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title']  = $this->data['page']['title'];

		$this->data['albums'] = [];
		$this->data['gallery'] = \App\AlbumCategory::where('id', '=', '3')->orWhere('id', '=', '2')->get();
		$this->data['gallery']->each(function($gallery){
			$gallery->structure();
			$albums = $gallery->albums()->with('category')->get();
			$albums->each(function($album){
				$album->structure();
				$this->data['albums'][] = $album;
			});
		});

		$this->getMeta();
		return view('themes.'.\Config::get('app.theme').'.pages.albums',$this->data);
	}

}
