<?php

namespace App\Http\Controllers\FrontEnd;


use Illuminate\Http\Request;
use App;
use App\Page;
use Illuminate\Support\Facades\Artisan;
use App\Traits\Afrodien;
use App\Http\Controllers\Controller;


class MainController extends Controller{

	use Afrodien;

	public $data = [];

	public function __construct(){
		$this->prepareViewer();
	}


	public function index($slug='home'){
		$this->viewPage($slug);
		$this->viewCategory($slug);


        if($slug=='search'){
            return $this->viewSearch('') ;
        }

		$this->getMeta();
		if(isset($this->view)){
			return view($this->view,$this->data);
		}
		return abort(404);
	}

	public function viewPage($slug){
		$this->data['page'] = Page::active()->with('slider')->where('slug', '=', $slug)->first();
		if ($this->data['page']) {

            if(isset($this->data['page']->slider->slides)){
                $this->data['page']->slider->slides->each(function($slides){
        			$slides->structure();
        		});
            }

			$this->view = "themes.".\Config::get('app.theme').".pages.".$slug;

			$this->data['page']->structure();
			$this->data['title'] = $this->data['page']['title'];

			if ($slug == 'home') {
				$this->viewHome();
			}elseif ($slug == 'blog') {
				$this->viewBlog();
			}

			if($slug=='about'){
				$this->data['portfolios'] = \App\Post::active()->with('category')->where('post_category_id','1')->latest()->limit(9)->get();
			}

			if($slug=='faqs'){
				$this->data['faqs'] = \DB::table('faqs')->latest()->paginate(\Config::get('app.itemsPerPage'));
			}

			if(!view()->exists($this->view)){
				$this->view = "themes.".\Config::get('app.theme').".pages.content";
			}

		}
	}

	public function viewHome(){

		$this->data['news'] = \App\Post::active()->with('category')->where('post_category_id','5')->latest()->limit(3)->get();
		$this->data['news']->each(function($post){
			$post->structure();
			$post->category->structure();
		});

		$this->data['quick_links'] = \DB::table('quick_links')->get();
		$this->data['quick_links']->each(function($post){
			$prefix = 'title_'.\Config::get('app.locale');
			$post->title = $post->$prefix;

		});

		$this->data['Life_at_MLHS'] = \App\Post::active()->with('category')->where('post_category_id','1')->latest()->limit(3)->get();
		$this->data['Life_at_MLHS']->each(function($post){
			$post->structure();
			$post->category->structure();
		});

		$this->data['calendar'] = \DB::table('calendar')->where('end_date', '>', \DB::raw('NOW()'))->get();
		$this->data['calendar']->each(function($post){
			$prefix = 'title_'.\Config::get('app.locale');
			$post->title = $post->$prefix;
		});


		return view("themes.".\Config::get('app.theme').".pages.home",$this->data);
	}

	public function viewBlog(){
		$this->aside();
		$this->data['posts'] = \App\Post::active()->with('user')->has('not_isolated_category')->latest()->paginate(\Config::get('app.itemsPerPage'));
		return view("themes.".\Config::get('app.theme').".pages.blog",$this->data);
	}

	public function viewCategory($slug){
		$this->data['category'] = \App\PostCategory::active()->where('category_slug', '=', $slug)->with('posts')->first();
		if ($this->data['category']) {
			$this->aside();
			$this->data['category']->structure();
			$this->data['posts'] = $this->data['category']->posts()->active()->latest()->paginate(\Config::get('app.itemsPerPage'));
			$this->data['title'] = $this->data['category']['title'];
			$this->view = "themes.".\Config::get('app.theme').".pages.blog";
			if($this->data['category']['is_custom']==1){
				$this->view = "themes.".\Config::get('app.theme').".pages.".$this->data['category']['category_slug'];
			}
		}
	}

	public function viewPost($category_slug,$post_slug){
		$this->data['post'] = \App\Post::active()->with('user','comments','category')->whereHas(
			'category', function ($query) use ($category_slug) {
		    	return $query->where('category_slug', '=', $category_slug);
			})->where([
				'post_slug' => $post_slug,
			])->first();
		if($this->data['post']){
			$this->data['post']->structure();
			$this->data['post']['category']->structure();
			$this->data['title'] = $this->data['post']['title'];
			$this->aside();
			$this->getMeta();
			return view("themes.".\Config::get('app.theme').".pages.post",$this->data);
		}

		return \App::call('App\Http\Controllers\FrontEnd\StoreController@view');


	}

	public function viewTag($slug){
		$this->aside();
		$this->data['tag']   = App\PostTag::where('tag_slug', $slug)->with('posts')->firstOrFail();
		$this->data['tag']->structure();
		$this->data['posts'] = $this->data['tag']->posts()->active()->paginate(\Config::get('app.itemsPerPage'));
		$this->data['title'] = $this->data['tag']['title'];
		$this->getMeta();
		return view("themes.".\Config::get('app.theme').".pages.blog",$this->data);
	}

	public function viewSearch($term){
		$this->aside();
		$this->data['page'] = Page::active()->where('slug', '=', 'search')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->data['posts'] = \App\Post::active()->where('post_title_'.\App::getLocale(),'like','%'.$term.'%')->with('user')->paginate(\Config::get('app.itemsPerPage'));
		$this->getMeta();
		return view("themes.".\Config::get('app.theme').".pages.search",$this->data);
	}

	public function aside(){

		$this->data['latestPosts'] = \App\Post::active()->with('category')->latest()->limit(3)->get();
		$this->data['latestPosts']->each(function($post){
			$post->structure();
		});

		$this->data['popularCategories'] = \App\PostCategory::active()->whereIn('category_id',explode(',',\Config::get('app.popular.categories')))->limit(5)->get();
		$this->data['popularCategories']->each(function($category){
			$category->structure();
		});

		$this->data['trendingTags'] = \App\PostTag::whereIn('tag_id',explode(',',\Config::get('app.popular.tags')))->limit(5)->get();;
		$this->data['trendingTags']->each(function($tag){
			$tag->structure();
		});

	}

}
