<?php

namespace App\Http\Controllers\FrontEnd;


use Illuminate\Http\Request;
use App;
use App\Album;
use App\Page;
use Illuminate\Support\Facades\Artisan;
use App\Traits\Afrodien;
use App\Http\Controllers\Controller;


class PageController extends Controller{

	use Afrodien;

	public $data = [];

	public function __construct(){
		$this->prepareViewer();
	}


	public function download(Request $request){

		$page = \App\Page::where('slug',$request->slug)->first();
		$file = \DB::table('files')->where('slug',$page->id)->where('grade',$request->grade)->orderBy('id', 'desc')->first();



		if($file){
			return redirect('/storage/pdf-files/'.$file->pdf);
		}
		return abort(404);
	}

	public function postSlug(Request $request, $category, $slug){
		$data = null;
		$data = $data ? $data : app('App\Http\Controllers\FrontEnd\BlogController')->viewPost($request,$category,$slug);
		$data = $data ? $data : app('App\Http\Controllers\FrontEnd\StoreController')->view($request,$category,$slug);
		$data = $data ? $data : app('App\Http\Controllers\FrontEnd\ServiceController')->view($request,$category,$slug);
		$data = $data ? $data : app('App\Http\Controllers\FrontEnd\GalleryController')->viewCategory($request,$slug);
		$data = $data ? $data : abort(404);
		return $data;
	}

	public function index($slug='home'){


		if($slug=='store'){
			return app('App\Http\Controllers\FrontEnd\StoreController')->index();
		}

		if($slug=='blog'){
			return app('App\Http\Controllers\FrontEnd\BlogController')->index();
		}

		if($slug=='services'){
			return app('App\Http\Controllers\FrontEnd\ServiceController')->index();
		}

		if($slug=='gallery'){
			return app('App\Http\Controllers\FrontEnd\GalleryController')->index();
		}

		$this->viewPage($slug);

		if(!$this->data['page']){
			return app('App\Http\Controllers\FrontEnd\BlogController')->viewCategory($slug);
		}

        if($slug=='search'){
            return $this->viewSearch('') ;
        }

		$this->getMeta();
		if(isset($this->view)){
			return view($this->view,$this->data);
		}

		return abort(404);
	}

	public function viewPage($slug){
		$this->data['page'] = Page::active()->with('slider')->where('slug', '=', $slug)->first();
		if ($this->data['page']){

            if(isset($this->data['page']->slider->slides)){
                $this->data['page']->slider->slides->each(function($slides){
        			$slides->structure();
        		});
            }

			$this->view = "themes.".\Config::get('app.theme').".pages.".$slug;

			$this->data['page']->structure();
			$this->data['title'] = $this->data['page']['title'];


			preg_match_all('#\[gallery\](.*?)\[\/gallery\]#is', $this->data['page']['content'], $matches);
			foreach ($matches[0] as $i => $value) {
				$Gallery = \App\Album::where('id', $matches[1][$i])->first();
				$Conten = '<div class="owl-carousel">';
				if($Gallery){
					foreach ($Gallery->media() as $media) {
						$Conten .= '<a class="venobox" href="'.$media['src'].'"> <img src="'.$media['src'].'" /> </a>';
					}
				}
				$Conten .= '</div>';

				$this->data['page']['content'] = \str_replace($value,$Conten, $this->data['page']['content']);
			}

			if(isset($this->data['page']['parent']) && !empty($this->data['page']['parent'])){
				$this->data['pages'] = Page::active()->where('parent', '=', $this->data['page']['parent'])->get();
				$this->data['pages']->each(function($page){
					$page->structure();
				});
			}


			if ($slug == 'home') {
				$this->viewHome();
			}

			if($slug=='about'){
				$this->data['portfolios'] = \App\Post::active()->with('category')->where('post_category_id','1')->latest()->limit(9)->get();
			}

			if($slug=='faqs'){
				$this->data['faqs'] = \DB::table('faqs')->latest()->paginate(\Config::get('app.itemsPerPage'));
			}

			if(!view()->exists($this->view) && isset($this->data['page']['parent']) && !empty($this->data['page']['parent'])){
				$parent = Page::active()->where('id', '=', $this->data['page']['parent'])->first();
				$this->view = "themes.".\Config::get('app.theme').".pages.".$parent['slug'];
			}

			if(!view()->exists($this->view)){
				$this->view = "themes.".\Config::get('app.theme').".pages.content";
			}

		}
	}

	public function viewHome(){


		$this->data['news'] = \App\Post::active()->orderBy('date','DESC')->with('category')->where('post_category_id','5')->latest()->limit(3)->get();
		$this->data['news']->each(function($post){
			$post->structure();
			$post->category->structure();
		});

		$this->data['quick_links'] = \DB::table('quick_links')->get();
		$this->data['quick_links']->each(function($post){
			$prefix = 'title_'.\Config::get('app.locale');
			$post->title = $post->$prefix;

		});

		$this->data['Life_at_MLHS'] = \App\Post::active()->with('category')->where('post_category_id','1')->orderBy('date','DESC')->limit(3)->get();
		$this->data['Life_at_MLHS']->each(function($post){
			$post->structure();
			$post->category->structure();
		});

		$this->data['calendar'] = \DB::table('calendar')->whereDate('end_date', '>=' , \Carbon\Carbon::today())->get();
		$this->data['calendar']->each(function($post){
			$prefix = 'title_'.\Config::get('app.locale');
			$post->title = $post->$prefix;


		});

		return view("themes.".\Config::get('app.theme').".pages.home",$this->data);

	}

}
