<?php

namespace App\Http\Controllers\FrontEnd;

use Illuminate\Http\Request;
use App;
use App\Page;
use Illuminate\Support\Facades\Artisan;
use App\Traits\Afrodien;
use App\Http\Controllers\Controller;


class ProductController extends Controller{

	use Afrodien;

	public $data = [];

	public function __construct(){
		$this->prepareViewer();
	}

	public function index(){
		$this->data['page'] = \App\Page::where('slug', '=', 'services')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->data['services'] = \App\Service::with('category')->latest()->paginate(\Config::get('app.itemsPerPage'));
		$this->data['services']->each(function($service){
			$service->structure();
			$service->category->structure();
		});
		$this->getMeta();
		return view('themes.'.\Config::get('app.theme').'.pages.services',$this->data);
	}

	public function view($slug){
		$this->data['page'] = \App\Service::with('category')->with('media')->with('reviews')->where('slug',$slug)->firstOrFail();
		$this->data['page']->structure();
		$this->data['page']->category->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->related();
		$this->aside();
		$this->getMeta();
		return view('themes.'.\Config::get('app.theme').'.pages.service',$this->data);
	}


	public function related(){
		$this->data['related'] = \App\Service::where('category_id',$this->data['page']->category_id)->where('id','!=',$this->data['page']->id)->get();
		$this->data['related']->each(function($service){
			$service->structure();
		});
	}

	public function aside(){

		$this->data['latestPosts'] = \App\Post::active()->with('category')->latest()->limit(3)->get();
		$this->data['latestPosts']->each(function($post){
			$post->structure();
		});

		$this->data['popularCategories'] = \App\PostCategory::active()->whereIn('category_id',explode(',',\Config::get('app.popular.categories')))->limit(5)->get();
		$this->data['popularCategories']->each(function($category){
			$category->structure();
		});

		$this->data['trendingTags'] = \App\PostTag::whereIn('tag_id',explode(',',\Config::get('app.popular.tags')))->limit(5)->get();;
		$this->data['trendingTags']->each(function($tag){
			$tag->structure();
		});

	}

}
