<?php

namespace App\Http\Controllers\FrontEnd;


use Illuminate\Http\Request;
use App;
use App\Page;
use Illuminate\Support\Facades\Artisan;
use App\Traits\Afrodien;
use App\Http\Controllers\Controller;


class SearchController extends Controller{

	use Afrodien;

	public $data = [];

	public function __construct(){
		$this->prepareViewer();
	}

	public function aside(){

		$this->data['latestPosts'] = \App\Post::active()->with('category')->latest()->limit(3)->get();
		$this->data['latestPosts']->each(function($post){
			$post->structure();
		});

		$this->data['popularCategories'] = \App\PostCategory::active()->whereIn('category_id',explode(',',\Config::get('app.popular.categories')))->limit(5)->get();
		$this->data['popularCategories']->each(function($category){
			$category->structure();
		});

		$this->data['trendingTags'] = \App\PostTag::whereIn('tag_id',explode(',',\Config::get('app.popular.tags')))->limit(5)->get();;
		$this->data['trendingTags']->each(function($tag){
			$tag->structure();
		});

	}

	public function index($term){
		$this->aside();
		$this->data['page'] = Page::active()->where('slug', '=', 'search')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->data['posts'] = \App\Post::active()->where('post_title_'.\App::getLocale(),'like','%'.$term.'%')->with('user')->paginate(\Config::get('app.itemsPerPage'));
		$this->getMeta();
		return view("themes.".\Config::get('app.theme').".pages.search",$this->data);
	}

}
