<?php

namespace App\Http\Controllers\FrontEnd;

use Illuminate\Http\Request;
use App;
use App\Page;
use Illuminate\Support\Facades\Artisan;
use App\Traits\Afrodien;
use App\Http\Controllers\Controller;


class StoreController extends Controller{

	use Afrodien;

	public $data = [];

	public function __construct(){
		$this->prepareViewer();
	}

	public function index(){
		$this->data['page'] = \App\Page::where('slug', '=', 'store')->firstOrFail();
		$this->data['page']->structure();
		$this->data['title'] = $this->data['page']['title'];
		$this->data['products'] = \App\Product::with('category')->latest()->paginate(\Config::get('app.itemsPerPage'));
		$this->data['products']->each(function($product){
			$product->structure();
			$product->category->structure();
		});
		$this->getMeta();
		return view('themes.'.\Config::get('app.theme').'.pages.store',$this->data);
	}

	public function view(Request $request ,$category, $slug){
		$this->data['page'] = \App\Product::with('category')->with('media')->with('reviews')->where('slug',$slug)->first();
		if($this->data['page']){
			$this->data['page']->structure();
			$this->data['page']->category->structure();
			$this->data['title'] = $this->data['page']['title'];
			$this->related();
			$this->aside();
			$this->getMeta();
			return view('themes.'.\Config::get('app.theme').'.pages.product',$this->data);
		}
	}

	public function related(){
		$this->data['related'] = \App\Product::where('category_id',$this->data['page']->category_id)->where('id','!=',$this->data['page']->id)->get();
		$this->data['related']->each(function($product){
			$product->structure();
		});
	}

	public function aside(){

		$this->data['latestPosts'] = \App\Post::active()->with('category')->latest()->limit(3)->get();
		$this->data['latestPosts']->each(function($post){
			$post->structure();
		});

		$this->data['popularCategories'] = \App\PostCategory::active()->whereIn('category_id',explode(',',\Config::get('app.popular.categories')))->limit(5)->get();
		$this->data['popularCategories']->each(function($category){
			$category->structure();
		});

		$this->data['trendingTags'] = \App\PostTag::whereIn('tag_id',explode(',',\Config::get('app.popular.tags')))->limit(5)->get();;
		$this->data['trendingTags']->each(function($tag){
			$tag->structure();
		});

	}

}
