<?php
namespace App\Http\Middleware;

use Closure;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     * @param $request
     * @param Closure $next
     * @param $role
     * @param null $permission
     * @return mixed
     */
	 protected $ignore = ['profile','edit-profile','change-password'];

		public function handle($request, Closure $next, $role = null){


		if(\Auth::check() && \Request::segment(1)=="dashboard"){

			if(in_array(\Request::segment(2),$this->ignore)){
				return $next($request);
			}

			if(\Auth::user()->can('root-access')){
				return $next($request);
			}

			if(!empty(\Request::segment(2))){
				if(!\Auth::user()->can('view-'.\Request::segment(2))){
					\abort(403,'This action is unauthorized.');
				}

				if(!empty(\Request::segment(3)) && \Request::segment(3)!='data'){
					if(!\Auth::user()->can(\Request::segment(3).'-'.\Request::segment(2))){
						\abort(403,'This action is unauthorized.');
					}
				}
			}

		}

        return $next($request);

    }

}
