<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;

class Post extends Model
{

	use Afrodien;


    // Set mass-assignable fields
    protected $fillable = ['title', 'content', 'category', 'slug'];
	protected $primaryKey = 'post_id';

    /**
     * Get the route key for the model.
     *
     * @return string
     */
    public function getRouteKeyName()
    {
        return 'post_slug';
    }

	public function scopeActive($query) {
	    return $query->where('post_status', 'published')->where('post_title_'.\Config::get('app.locale'), '!=', '');
	}

	public function category(){
		return $this->belongsTo("App\PostCategory",'post_category_id');
    }

	public function not_isolated_category(){
		return $this->category()->where('isolate','!=','1');
    }

	public function comments()
    {
        return $this->hasMany(Comment::class,'post_id')->active()->whereNull('parent_id');
    }

	public function tags()
    {
        return $this->hasMany(Tag::class);
    }

    public function user()
    {
		return $this->belongsTo("App\User",'created_by');
    }

	public function thumbnail($Quality=100){
		if(
			isset($this->post_featured_image) && !empty($this->post_featured_image)
		 	&& \file_exists(storage_path('app/public/images/thumbnail/'.$Quality.'/',$this->post_featured_image.'.webp'))
	 	){
			$image = $this->image('/images/thumbnail/'.$Quality.'/',$this->post_featured_image.'.webp');
		}else{
			$image = $this->getFeaturedImage();
		}
		return $image;
	}


	public function getFeaturedImage(){
		if(isset($this->post_featured_image) && !empty($this->post_featured_image) && \file_exists(storage_path('app/public/images/original/'.$this->post_featured_image))){
			$image = $this->image('/images/original/',$this->post_featured_image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function url(){
		return isset($this['category']['category_slug'],$this['post_slug']) ? route('frontend.blog.post',['category_slug'=>$this->category->category_slug, 'post_slug'=>$this->post_slug]) : "";
	}

	public function structure(){
		$Locale = \App::getLocale();
		$this['title']         = isset($this['post_title_'.$Locale]) ? $this['post_title_'.$Locale] : "";
		$this['description']   = isset($this['post_description_'.$Locale]) ? $this['post_description_'.$Locale] : "";
		$this['content']       = isset($this['post_content_'.$Locale]) ? \base64_decode($this['post_content_'.$Locale]) : "";
		$this['featuredImage'] = $this->getFeaturedImage();
		$this['thumbnail']     = $this->thumbnail();
		$this['url']           = $this->url();
	}

}
