<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;

class PostCategory extends Model
{
	use Afrodien;


	protected $table = 'posts_categories';
	protected $primaryKey = 'category_id';

	public function posts(){
		return $this->hasMany(Post::class,'post_category_id');
	}

	public function url(){
		return isset($this['category_slug']) ? \route('frontend.page',['page_slug'=>$this['category_slug']]) : "";
	}

	public function structure(){
        $Locale = \App::getLocale();
        $this['title']         = isset($this['category_title_'.$Locale]) ? $this['category_title_'.$Locale] : "";
        $this['description']   = isset($this['category_description_'.$Locale]) ? $this['category_description_'.$Locale] : "";
        $this['content']       = isset($this['category_content_'.$Locale]) ? \base64_decode($this['category_content_'.$Locale]) : "";
		$this['url']           = $this->url();
		$this['featuredImage'] = $this->getFeaturedImage();
	}

	public function getFeaturedImage(){
		if(isset($this->category_featured_image) && !empty($this->category_featured_image) && \file_exists(storage_path().'/images/original/'.$this->category_featured_image)){
			$image = $this->image('/images/original/',$this->category_featured_image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function scopeActive($query) {
		return $query->where('category_status', 'published');
	}

}
