<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;

class Product extends Model{

	use Afrodien;

	public function users(){
        return $this->belongsToMany('App\User')->using('App\UserProduct');
    }

	public function category(){
        return $this->belongsTo('App\ProductCategory','category_id','id');
    }

	public function media(){
		return $this->hasManyThrough('App\Media','App\ProductMedia','product_id','id','id','media_id');
    }

	public function reviews(){
        return $this->hasMany('App\ProductReview')->with('user');
    }

	public function webp(){
		if(isset($this->featured_image) && !empty($this->featured_image) && \file_exists(storage_path('app/public/images/webp/'.$this->featured_image.'.webp'))){
			$image = $this->image('/images/webp/',$this->featured_image.'.webp');
		}else{
			$image = $this->getFeaturedImage();
		}
		return $image;
	}

	public function thumbnail(){
		if(isset($this->featured_image) && !empty($this->featured_image) && \file_exists(storage_path('app/public/images/thumbnail/'.$this->featured_image))){
			$image = $this->image('/images/thumbnail/',$this->featured_image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function getFeaturedImage(){
		if(isset($this->featured_image) && !empty($this->featured_image) && \file_exists(storage_path('app/public/images/original/'.$this->featured_image))){
			$image = $this->image('/images/original/',$this->featured_image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

	public function url(){
		return isset($this['category']['slug'],$this['slug']) ? route('frontend.blog.post',['category_slug'=>$this->category->slug, 'post_slug'=>$this->slug]) : "";
	}

	public function structure(){
		$Locale = \App::getLocale();
		$this['title']         = isset($this['title_'.$Locale]) ? $this['title_'.$Locale] : "";
		$this['description']   = isset($this['description_'.$Locale]) ? $this['description_'.$Locale] : "";
		$this['details']       = isset($this['details_'.$Locale]) ? \base64_decode($this['details_'.$Locale]) : "";
		$this['featuredImage'] = $this->getFeaturedImage();
		$this['thumbnail']     = $this->thumbnail();
		$this['url']           = $this->url();

	}

}
