<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Afrodien;

class ProductCategory extends Model{

	use Afrodien;

	protected $table = 'products_categories';

	public function url(){
		return isset($this['slug']) ? \route('frontend.page',['page_slug'=>$this['slug']]) : "";
	}

	public function structure(){
        $Locale = \App::getLocale();
        $this['title']         = isset($this['title_'.$Locale]) ? $this['title_'.$Locale] : "";
        $this['description']   = isset($this['description_'.$Locale]) ? $this['description_'.$Locale] : "";
		$this['url']           = $this->url();
		$this['featuredImage'] = $this->getFeaturedImage();
	}

	public function getFeaturedImage(){
		if(isset($this->featured_image) && !empty($this->featured_image) && \file_exists(storage_path().'/images/original/'.$this->featured_image)){
			$image = $this->image('/images/original/',$this->featured_image);
		}else{
			$image = $this->image('/',\Config::get('app.default.featuredImage'));
		}
		return $image;
	}

}
