<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SupportTicket extends Model
{
    protected $guarded=[];

	protected $table = 'support_tickets';

	public function messages(){
        return $this->hasMany("App\SupportTicketMessage",'ticket_uuid','ticket_uuid')->with('user');
    }

	public function user(){
		return $this->belongsTo("App\User",'user_id');
    }

	public function department(){
		return $this->belongsTo("App\SupportDepartment",'department_id');
	}


}
