<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Survey extends Model{

	protected $table = 'surveys';

	public function roles(){
        return $this->belongsToMany(UserRole::class,'for_surveys_users_roles_r');
    }

	public function domains(){
        return $this->hasMany(SurveyDomain::class)->with('rating')->with('elements');
    }

	public function operations($id){
		return '
			<a class="btn btn-success btn-sm" href="'.\route('dashboard.surveys.reports',['id'=>$id]).'">
				<i class="fas fa-chart-line"></i>
			</a>
		';
	}


}
