<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id('post_id');
			$table->string('post_slug')->unique();
            $table->string('post_title_en');
            $table->string('post_title_ar');
            $table->text('post_description_en');
            $table->text('post_description_ar');
            $table->longText('post_content_en');
            $table->longText('post_content_ar');
            $table->bigInteger('created_by');
            $table->bigInteger('post_category_id');
            $table->string('post_status');
            $table->string('post_comment_status');
			$table->string('post_featured_image');
            $table->timestamps();
			$table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('posts');
    }
}
