<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
			$table->uuid('visitor_id');
            $table->bigInteger('page_id')->nullable();
			$table->bigInteger('post_id')->nullable();
            $table->bigInteger('category_id')->nullable();
            $table->bigInteger('tag_id')->nullable();
			$table->string('search_term')->nullable();
            $table->string('url');
			$table->string('locale');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reports');
    }
}
