<!DOCTYPE html>
<html lang="{{Config::get('app.locale')}}" dir="{{json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']}}">

    <head>

        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />

	    <!-- Tell the browser to be responsive to screen width -->
	    <meta name="viewport" content="width=device-width, initial-scale=1">

		<!-- Google Font: Source Sans Pro -->
        <meta name="csrf-token" content="{{csrf_token()}}">

	    <title>{{config('app.name')[Config::get('app.locale')]}} | {{config('app.customer-area.title')[Config::get('app.locale')]}}</title>


		<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet" />


		<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;600;700;900&display=swap" rel="stylesheet">


		<!-- Google Font: Source Sans Pro -->
        <link rel="stylesheet" href="{{ asset("/plugins/toastr/toastr.min.css") }}" />

        <!-- Google Font: Source Sans Pro -->
        <link rel="stylesheet" href="{{ asset("/plugins/select2/css/select2.min.css") }}" />

	    <link rel="stylesheet" type="text/css" href="{{asset('/plugins/matrix-admin-bt4')}}/assets/extra-libs/multicheck/multicheck.css">

		<link rel="stylesheet" href="{{ asset("/plugins/fontawesome-free/css/all.min.css") }}" />

        <link rel="stylesheet" href="{{ asset("/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css") }}" />
        <link rel="stylesheet" href="{{ asset("/plugins/datatables-buttons/css/buttons.bootstrap4.min.css") }}" />

	    <link href="{{asset('/plugins/matrix-admin-bt4')}}/dist/css/style.min.css" rel="stylesheet">

		@if( json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']=="rtl")
			<link rel="stylesheet" href="https://cdn.rtlcss.com/bootstrap/v4.2.1/css/bootstrap.min.css" integrity="sha384-vus3nQHTD+5mpDiZ4rkEPlnkcyTP+49BhJ4wJeJunw06ZAp+wzzeBPUXr42fi8If" crossorigin="anonymous">
		@endif

	    <link href="{{asset('/plugins/matrix-admin-bt4')}}/dist/css/custom.css" rel="stylesheet">

		@if( json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']=="rtl")
			<link href="{{asset('/plugins/matrix-admin-bt4')}}/dist/css/custom.rtl.css" rel="stylesheet">
		@endif

		<link rel="shortcut icon" href="{{url('/storage/'.config('app.favicon'))}}">

		<base href="{{url('')}}" />
		<meta name="home" content="{{route('frontend.index')}}" />



		<script type="text/javascript">
			var languages = {!! json_encode(Config::get('app.languages')) !!};
            var dataTableLanguage = {
                "lengthMenu": "{{__(('sLengthMenu'))}}",
                "zeroRecords": "{{__(('sEmptyTable'))}}",
                "info": "{{__(('sInfo'))}}",
                "processing": "{{__(('sProcessing'))}}",
                "infoEmpty": "{{__(('sInfoEmpty'))}}",
                "infoFiltered": "{{__(('sInfoFiltered'))}}",
                "zeroRecords": "{{__(('sZeroRecords'))}}",
                "emptyTable": "{{__(('sEmptyTable'))}}",
                "search": '<i class="fas fa-search"></i>',
                paginate: {
                    "next" : "{{__(('oPaginate.sNext'))}}",
                    "previous" : "{{__(('oPaginate.sPrevious'))}}",
                },
                buttons: {
                    pageLength: {
                        _: '<i class="fas fa-list"></i> %d',
                        '-1': '<i class="fas fa-td"></i> all',
                    }
                }
            };
		</script>

	</head>

	<body>

		<div class="preloader">
			<div class="lds-ripple">
				<div class="lds-pos"></div>
				<div class="lds-pos"></div>
			</div>
		</div>

		<div id="main-wrapper">
			@include('customer.inc.header')

			@include('customer.inc.aside')

			<div class="page-wrapper">

				@include('customer.inc.breadcrumb')

				@include('customer.inc.container')

				@include('customer.inc.footer')

			</div>

		</div>



        <!-- jQuery -->
        <script src="{{ asset("/plugins/jquery/jquery.min.js") }}"></script>

		<!-- Bootstrap 4 -->
        <script src="{{ asset("/plugins/bootstrap/js/bootstrap.bundle.min.js") }}"></script>

		<!-- Bootstrap tether Core JavaScript -->
		<script src="{{asset('/plugins/matrix-admin-bt4')}}/assets/libs/popper.js/dist/umd/popper.min.js"></script>
		<script src="{{asset('/plugins/matrix-admin-bt4')}}/assets/libs/perfect-scrollbar/dist/perfect-scrollbar.jquery.min.js"></script>

		<!--Wave Effects -->
		<script src="{{asset('/plugins/matrix-admin-bt4')}}/dist/js/waves.js"></script>

		<!--Menu sidebar -->
		<script src="{{asset('/plugins/matrix-admin-bt4')}}/dist/js/sidebarmenu.js"></script>

		<script src="{{ asset("/plugins/select2/js/select2.full.min.js") }}"></script>

		<script src="{{asset('/plugins/matrix-admin-bt4')}}/assets/extra-libs/multicheck/datatable-checkbox-init.js"></script>
		<script src="{{asset('/plugins/matrix-admin-bt4')}}/assets/extra-libs/multicheck/jquery.multicheck.js"></script>

		<script src="{{ asset("/plugins/datatables/jquery.dataTables.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/dataTables.buttons.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.bootstrap4.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.colVis.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.html5.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.print.min.js") }}"></script>

		<!-- AdminLTE App -->
        <script src="{{ asset("/plugins/toastr/toastr.min.js") }}"></script>

		<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.16/dist/summernote-bs4.min.js"></script>
		<script src="{{ asset("/plugins/afrodien/js/afrodien-summernote.js") }}"></script>

		<!-- Firebase App (the core Firebase SDK) is always required and must be listed first -->
		<script src="https://www.gstatic.com/firebasejs/7.16.1/firebase-app.js"></script>

		<!-- Firebase messaging -->
		<script src="https://www.gstatic.com/firebasejs/7.16.1/firebase-messaging.js"></script>

		<!-- Afrodien App JS -->
		<script src="{{ asset("/plugins/afrodien/js/app.js") }}"></script>

		<!--Custom JavaScript -->
		<script src="{{asset('/plugins/matrix-admin-bt4')}}/dist/js/custom.min.js"></script>

		@yield('script')

		<form id="logout-form" action="{{ route('logout' , []) }}" method="POST" style="display: none;">
			@csrf
		</form>

	</body>

</html>
