@extends('customer.layout')

@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-md-flex align-items-center">
                        <div>
                            <h4 class="card-title">{{__('Overview')}}</h4>
                            <hr>
                        </div>
                    </div>
                    <div class="row">

                        <div class="col-12">
                            <div class="row">
                                <div class="col-md-6 col-lg-3 m-t-10">
                                    <div class="bg-dark p-4 text-white text-center">
                                        <i class="fa fa-ticket-alt m-b-5 font-16"></i>
                                        <h5 class="m-b-0 m-t-5">{{$totalCount}}</h5>
                                        <small class="font-light">{{__('Total Tickets')}}</small>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-3 m-t-10">
                                    <div class="bg-dark p-4 text-white text-center">
                                        <i class="fa fa-hourglass-end m-b-5 font-16"></i>
                                        <h5 class="m-b-0 m-t-5">{{$awaitingCount}}</h5>
                                        <small class="font-light">{{__('Waiting For Reply')}}</small>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-3 m-t-10">
                                    <div class="bg-dark p-4 text-white text-center">
                                        <i class="fa fa-gavel m-b-5 font-16"></i>
                                        <h5 class="m-b-0 m-t-5">{{$inprogressCount}}</h5>
                                        <small class="font-light">{{__('inprogress')}}</small>
                                    </div>
                                </div>
                                <div class="col-md-6 col-lg-3 m-t-10">
                                    <div class="bg-dark p-4 text-white text-center">
                                        <i class="fa fa-tag m-b-5 font-16"></i>
                                        <h5 class="m-b-0 m-t-5">{{$closedCount}}</h5>
                                        <small class="font-light">{{__('Total Closed')}}</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- column -->
                    </div>
                </div>
            </div>
        </div>
    </div>

	<div class="row">
        <div class="col-12">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body bg-secondary text-white col-12">
                            <div class="row">
								<div class="col-12">
									<h4 class="card-title">{{__('Recent Surveys')}}</h4>
								</div>
                            </div>

                        </div>

                        <div class="table-responsive">
							<table class="table">
		                        <thead class="thead-light">
		                        <tr>
		                            <th scope="col">{{__('Survey ID')}}</th>
									<th scope="col">{{__('Survey Name')}}</th>
		                        </tr>
		                        </thead>
		                        <tbody class="customtable">
			                        @forelse ($Surveys as $survey)
			                            <tr>
			                                <td>{{$survey->id}}</td>
			                                <td><a href="{{route('customer.surveys.view',['id'=>$survey->id])}}">{{$survey->title}}</a></td>
			                            </tr>
									@empty
										<tr>
											<td colspan="3">{{__('No Surveys.')}}</td>
										</tr>
			                        @endforelse
		                        </tbody>
		                    </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body bg-secondary text-white col-12">
                            <div class="row">
								<div class="col-8">
									<h4 class="card-title">{{__('Recent Tickets')}}</h4>
								</div>
								<div class="col-4 text-not-as-lang">
	                                <a class="btn btn-light align-content-end" href="{{route('customer.tickets.create')}}">
										{{__('Open Ticket')}}
									</a>
							   </div>
                            </div>

                        </div>

                        <div class="table-responsive">
                            <table class="table">
                                <thead class="thead-light">
                                <tr>
                                    <th scope="col">{{__('Ticket ID')}}</th>
                                    <th scope="col">{{__('Title')}}</th>
                                    <th scope="col">{{__('Status')}}</th>
                                    <th scope="col">{{__('View')}}</th>
                                </tr>
                                </thead>
                                <tbody class="customtable">
                                @forelse($tickets as $ticket)
                                    <tr>
                                        <td>{{$ticket->ticket_uuid}}</td>
                                        <td>{{$ticket->title}}</td>
                                        <td>{{__($ticket->status)}}</td>
                                        <td>
											<a class="btn btn-dark" href="{{route('customer.tickets.view',$ticket->ticket_uuid)}}">{{__('View')}}</a>
                                        </td>
                                    </tr>
								@empty
									<tr><td colspan="4">{{__('you haven\'t created any ticket yet')}}</td></tr>
								@endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
