@extends('customer.layout')
@section('content')

<div class="row">
    <div class="col-md-12">

		<div class="card card-body printableArea">
		    <h3>
				<b>INVOICE</b>
				<br>
				<small class="pull-right">#{{$invoice->invoice_id}}</small>
			</h3>
		    <hr />
		    <div class="row">
		        <div class="col-md-12">
		            <div class="pull-left">
		                <address>
		                    <h3>&nbsp;<b class="text-danger">{{Config::get('app.name')[Config::get('app.locale')]}}</b></h3>
		                    <p class="text-muted m-l-5">
		                        {!! Config::get('app.invoice.address') !!}
		                    </p>
		                </address>
		            </div>
		            <div class="pull-right text-right">
		                <address>
		                    <h3>To,</h3>
		                    <h4 class="font-bold">{{auth()->user()->name}},</h4>
		                    <p class="text-muted m-l-30">
		                        {{auth()->user()->location}}
		                    </p>
		                    <p class="m-t-30"><b>Invoice Date :</b> <i class="fa fa-calendar"></i> {{Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $invoice->created_at)->format('Y M d')}}</p>
		                    <p><b>Due Date :</b> <i class="fa fa-calendar"></i> {{Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $invoice->due_date)->format('Y M d')}}</p>
		                </address>
		            </div>
		        </div>
		        <div class="col-md-12">
		            <div class="table-responsive m-t-40" style="clear: both;">
		                <table class="table table-hover">
		                    <thead>
		                        <tr>
		                            <th class="text-center">#</th>
		                            <th>Description</th>
		                            <th class="text-right">Quantity</th>
		                            <th class="text-right">Unit Cost</th>
		                            <th class="text-right">Total</th>
		                        </tr>
		                    </thead>
		                    <tbody>
								@foreach ($invoice->items as $item)
			                        <tr>
			                            <td class="text-center">{{$item->id}}</td>
			                            <td>{{$item->description}}</td>
			                            <td class="text-right">{{$item->quantity}}</td>
			                            <td class="text-right">{{$item->cost}}</td>
			                            <td class="text-right">{{$item->quantity*$item->cost}}</td>
			                        </tr>
								@endforeach
		                    </tbody>
		                </table>
		            </div>
		        </div>
		        <div class="col-md-12">
		            <div class="pull-right m-t-30 text-right">
		                <p>Sub - Total amount: ${{$invoice->total}}</p>
		                <p>Discount : {{$invoice->discount}}%</p>
		                <hr />
		                <h3><b>Total :</b> ${{( ($invoice->total) -($invoice->total/100*$invoice->discount) )}}</h3>
		            </div>
		            <div class="clearfix"></div>
					@if($invoice->status!='paid')
						<hr />
			            <div class="text-right">
			                <button class="btn btn-danger" type="submit">Proceed to payment</button>
			            </div>
					@endif
		        </div>
		    </div>
		</div>


    </div>
</div>

@endsection
