@extends('customer.layout')

@section('content')
  <div class="row">
      <div class="col-md-12">
          <div class="card">
              <form class="form-horizontal" action="{{ route('customer.profile.update-password') }}" method="post">
                @csrf
				<div class="card-header bg-secondary text-white">
					<h4 class="card-title">{{__('Change Password')}}</h4>
				</div>
                  <div class="card-body">
                      <div class="form-group mb-5 row">
                          <label for="old-password" class="col-sm-3 text-right control-label col-form-label">{{__('Current Password')}}</label>
                          <div class="col-sm-9">
                              <input type="password" class="form-control" name="old-password" id="old-password" placeholder="{{__('Current Password')}}" />
                          </div>
                      </div>
                      <div class="form-group row">
                          <label for="username" class="col-sm-3 text-right control-label col-form-label">{{__('New Password')}}</label>
                          <div class="col-sm-9">
                              <input type="password" class="form-control" name="password" id="password" placeholder="{{__('New Password')}}" />
                          </div>
                      </div>
                      <div class="form-group row">
                          <label for="username" class="col-sm-3 text-right control-label col-form-label">{{__('Confirm Password')}}</label>
                          <div class="col-sm-9">
                              <input type="password" class="form-control" name="password_confirmation" id="confirm-password" placeholder="{{__('Confirm Password')}}" />
                          </div>
                      </div>

						@if($errors->any())
							<div class="alert alert-danger">
								{{$errors->first()}}
							</div>
						@endif


						@if (\Session::has('success'))
						    <div class="alert alert-success">
					            {!! \Session::get('success') !!}
						    </div>
						@endif

                  </div>
                  <div class="border-top">
                      <div class="card-body">
                          <button type="submit" class="btn btn-primary">{{__('Submit')}}</button>
                      </div>
                  </div>
              </form>
          </div>

      </div>
  </div>
@endsection

@section('script')
<script>
$(document).ready(function() {
  $('.select2').select2();
})
</script>
@endsection
