@extends('customer.layout')
@section('content')

    @if($ticket->status=='closed')
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header text-white bg-secondary">
                        <h5 class="card-title  m-b-0">Rate Support service</h5>
                    </div>
                    <div class="card-body">
                        @if(empty($ticket->rate))
	                        <div class="row">
	                            <form class="col-12" action="{{route('customer.tickets.rating',$ticket->ticket_uuid)}}"
	                                  method="post">
	                                @csrf
	                                <div class="form-group col-12">
	                                    <label for="rate">Please Rate Our Service</label>
										<textarea class="form-control" name="notes" placeholder=""></textarea>
										<br>
										<div class="rating" style="width: 20rem">
											<input id="rating-5" type="radio" name="rating" value="5"  @if($ticket->rate==5) checked @endif />
											<label for="rating-5"><i class="fas fa-3x fa-star"></i></label>

											<input id="rating-4" type="radio" name="rating" value="4"  @if($ticket->rate==4) checked @endif />
											<label for="rating-4"><i class="fas fa-3x fa-star"></i></label>

											<input id="rating-3" type="radio" name="rating" value="3"  @if($ticket->rate==3) checked @endif />
											<label for="rating-3"><i class="fas fa-3x fa-star"></i></label>

											<input id="rating-2" type="radio" name="rating" value="2"  @if($ticket->rate==2) checked @endif />
											<label for="rating-2"><i class="fas fa-3x fa-star"></i></label>

											<input id="rating-1" type="radio" name="rating" value="1"  @if($ticket->rate==1) checked @endif />
											<label for="rating-1"><i class="fas fa-3x fa-star"></i></label>

		                                </div>
	                                </div>
	                                <button class="btn btn-success col-12">Submit</button>
	                            </form>
	                        </div>
						@else
							<div class="rating @empty(!$ticket->rate) disabled @endempty " style="width: 20rem">

								<input id="rating-5" type="radio" name="rating" value="5" disabled @if($ticket->rate==5) checked @endif />
								<label for="rating-5"><i class="fas fa-3x fa-star"></i></label>

								<input id="rating-4" type="radio" name="rating" value="4" disabled @if($ticket->rate==4) checked @endif />
								<label for="rating-4"><i class="fas fa-3x fa-star"></i></label>

								<input id="rating-3" type="radio" name="rating" value="3" disabled @if($ticket->rate==3) checked @endif />
								<label for="rating-3"><i class="fas fa-3x fa-star"></i></label>

								<input id="rating-2" type="radio" name="rating" value="2" disabled @if($ticket->rate==2) checked @endif />
								<label for="rating-2"><i class="fas fa-3x fa-star"></i></label>

								<input id="rating-1" type="radio" name="rating" value="1" disabled @if($ticket->rate==1) checked @endif />
								<label for="rating-1"><i class="fas fa-3x fa-star"></i></label>

							</div>
						@endif
                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header text-white bg-primary">
                    <h5 class="card-title  m-b-0">{{$ticket->title}}</h5>
                </div>
                <div class="card-body">
					<div class="chat-box ps-container ps-theme-default ps-active-y" data-ps-id="5ebaddd5-1839-7add-a7a0-b6d98d9819b5">
					    <!--chat Row -->
					    <ul class="chat-list">

							@foreach($ticket->messages as $message)
						        <li class=" @if($message->created_by == auth()->id()) odd @endif chat-item">
						            <div class="chat-img"><img src="{{$message->user->avatar()}}" alt="{{$message->user->name}}" /></div>
						            <div class="chat-content">
						                <h6 class="font-medium">{{$message->user->name}}</h6>
						                <div class="box bg-light-info">
											@if($message->created_by != auth()->id())
												@if(empty($message->note))
													<a class="float-right" href="{{route('customer.tickets.reporting',[$ticket->ticket_uuid,$message->id])}}">Report</a>
												@else
													<span class="float-right label label-danger">reported</span>
												@endif
											@endif
											{!!$message->message!!}
										</div>
						            </div>
						            <div class="chat-time">{{$message->created_at ? $message->created_at->diffForHumans(): 'No Time'}}</div>
								</li>
							@endforeach
					        <!--chat Row -->
					    </ul>
					</div>

					@if($ticket->status!='closed')
	                    <hr>

	                    <form method="post" class="chat" action="{{route('customer.tickets.reply')}}">
	                        @csrf
	                        <input type="hidden" value="{{$ticket->ticket_uuid}}" name="ticket_uuid" />

                            <textarea name="message" class="col-12 mb-5 summernote" placeholder="Enter Your Message" rows="5"></textarea>
                            <div class="text-right d-block">
                                <button class="btn btn-success">Submit</button>
                                <a href="{{route('customer.tickets.close',$ticket->ticket_uuid)}}" class="btn btn-danger text-white">Close Ticket</a>
                            </div>
	                    </form>
					@endif

                </div>
            </div>
        </div>
    </div>

@endsection
