<!-- Brand Logo -->
<a href="{{ route('frontend.index') }}" class="brand-link">
    <img src="{{url('/storage/'.config('app.logo.src'))}}" alt="{{ config('app.name')[Config::get('app.locale')] }}" class="brand-image img-circle elevation-3" style="opacity: .8">
    <span class="brand-text font-weight-light">{{ config('app.name')[Config::get('app.locale')] }}</span>
</a>

<!-- Sidebar -->
<div class="sidebar">



    <ul class="nav nav-pills nav-sidebar flex-column user-nav" data-widget="treeview" role="menu" data-accordion="false">
        <li class="user-panel nav-item has-treeview">
            <a class="d-flex nav-link" href="#">
				<div class="image">
					<img src="{{auth()->user()->avatar()}}" class="img-circle elevation-2" alt="{{ auth()->user()->name  }}" />
				</div>
                <div class="info">
                    {{auth()->user()->name}}
                </div>
                <i class="user_menu_icon fas fa-angle-down"></i>
            </a>
            <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="{{ route('dashboard.profile.index') }}" class="nav-link">
                        <i class="fas fa-user nav-icon"></i>
                        <p>{{__('My Profile')}}</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('dashboard.profile.edit') }}" class="nav-link">
                        <i class="fas fa-user-edit nav-icon"></i>
                        <p>{{__('Edit Profile')}}</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('dashboard.profile.change-password') }}" class="nav-link">
                        <i class="fas fa-unlock-alt nav-icon"></i>
                        <p>{{__('Change Password')}}</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('logout') }}" class="nav-link" onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                        <i class="fas fa-sign-out-alt nav-icon"></i>
                        <p>{{__('Logout')}}</p>
                    </a>
                </li>
            </ul>
        </li>
    </ul>

    <!-- Sidebar Menu -->
    <nav class="">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">

            @foreach(json_decode(file_get_contents(base_path('resources/views/dashboard/dashboard-nav.json')), true) as $item)

				@if(\Gate::check('view-'.$item['slug']) || \Gate::check('root-access') )

		            <li class="nav-item
						@if(!empty($item['sub'])) has-treeview @endif
						@foreach($item['sub'] as $subItem)
							@if(request('page_slug')==$subItem['slug']) menu-open @endif
							@if(
								\Route::current()->getName()=='dashboard.'.$item['slug'].".".$subItem['slug']
								||
								\Route::current()->getName()=='dashboard.'.$item['slug'].".index"
								||
								\Route::current()->getName()=='dashboard.'.$item['slug']
								) menu-open @endif
						@endforeach
					">
		                <a href="
						@if($item['isVirtual'])
							{{route('dashboard.virtual-system.index',['page_slug' => $item['slug']])}}
						@else
							@if (empty($item['slug']))
								{{route('dashboard.index')}}
							@else
								{{route('dashboard.'.$item['slug'].'.index')}}
							@endif
						@endif
						" class="nav-link
							@if(request('page_slug')==null && $item['slug']=="" && \Route::current()->getName()=="dashboard.index") active @endif
							@if(request('page_slug')!==null && request('page_slug')==$item['slug']) active @endif
							@if(\Route::current()->getName() == 'dashboard.'.$item['slug']) active @endif
							@foreach($item['sub'] as $subItem)
								@if(request('page_slug')==$subItem['slug']) active @endif
								@if(\Route::current()->getName()=='dashboard.'.$subItem['slug']) active @endif
								@if(\Route::current()->getName()=='dashboard.'.$subItem['slug'].".index") active @endif
								@if(\Route::current()->getName()=='dashboard.'.$item['slug'].".".$subItem['slug']) active @endif
							@endforeach
						">
		                    <i class="nav-icon {{$item['icon']}} "></i>
		                    <p>
		                        {{$item['title'][Config::get('app.locale')]}}
		                    </p>
							@if(!empty($item['sub']))
								<i class="right fas fa-angle-down"></i>
							@endif
		                </a>

						@if(!empty($item['sub']))
						<ul class="nav nav-treeview">
							@foreach($item['sub'] as $subItem)
				            <li class="nav-item">
				                <a href="
									@if($subItem['isVirtual'])
										{{route('dashboard.virtual-system.index',['page_slug' => $subItem['slug']])}}
									@else
										@if ($item['slug']==$subItem['slug'])
											{{route('dashboard.'.$item['slug'].'.index')}}
										@else
											{{route('dashboard.'.$item['slug'].".".$subItem['slug'])}}
										@endif
									@endif" class="nav-link
									@if(request('page_slug')==$subItem['slug']) active @endif
									@if(\Route::current()->getName()=='dashboard.'.$subItem['slug']) active @endif
									@if(\Route::current()->getName()=='dashboard.'.$subItem['slug'].".index") active @endif
									@if(\Route::current()->getName()=='dashboard.'.$item['slug'].".".$subItem['slug']) active @endif
								">
				                    <i class=" {{$subItem['icon']}} nav-icon"></i>
				                    <p>{{$subItem['title'][Config::get('app.locale')]}}</p>
				                </a>
				            </li>
							@endforeach
				        </ul>
						@endif
		            </li>
				@endif
            @endforeach
<li class="nav-item">
								<a href="javscript:void(0)" class="nav-link">
								<i class="nav-icon fas"></i>
									<p></p>
								</a>
							</li>
        </ul>
    </nav>
    <!-- /.sidebar-menu -->

</div>
<!-- /.sidebar -->
