<!-- Left navbar links -->
<ul class="navbar-nav">
    <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
    </li>
</ul>

<!-- SEARCH FORM -->
<form class="form-inline ml-3" action="{{route('dashboard.search.index')}}">
    <div class="input-group input-group-sm">
        <input class="form-control form-control-navbar" name="trim" autocomplete="off" type="search" value="{{\request('trim')}}" placeholder="{{__('Search')}}" aria-label="Search">
        <div class="input-group-append">
            <button class="btn btn-navbar" type="submit">
                <i class="fas fa-search"></i>
            </button>
        </div>
    </div>
</form>

<!-- Right navbar links -->
<ul class="navbar-nav ml-auto">
    <!-- Notifications Dropdown Menu -->
	<li class="nav-item dropdown">
		<a class="nav-link" href="#" id="navbardrop" data-toggle="dropdown" aria-expanded="false">
			<i class="fas fa-globe-africa"></i>
		</a>
		<div class="dropdown-menu" style="">
			@foreach(Config::get('app.languages') as $language)
				<a class="dropdown-item" href="{{url($language->prefix."/".Config::get('app.default.clean-uri'))}}">{{$language->name}}</a>
			@endforeach
		</div>
	</li>
    <li id="notifications" class="nav-item dropdown">
        <a class="nav-link" data-toggle="dropdown" href="#">
            <i class="far fa-bell"></i>
            <span class="badge badge-warning navbar-badge">{{ auth()->user()->unreadNotifications->count() }}</span>
        </a>
        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
            <span class="dropdown-item dropdown-header">{{ auth()->user()->unreadNotifications->count() }} {{__('New Notifications')}}</span>
            @forelse(auth()->user()->unreadNotifications as $notification)
                <div class="dropdown-divider"></div>
                <a href="{{ route('dashboard.notifications.view', [ 'notification' => $notification->id]) }}" class="dropdown-item">
                    <i class="fas fa-envelope mr-2"></i> {{ $notification->data['data'] }}
                    <span class="float-right text-muted text-sm">{{  (new Carbon\Carbon($notification->created_at))->diffForHumans() }}</span>
                </a>
            @empty
                <div class="dropdown-divider"></div>
                <a href="{{ route('dashboard.notifications.index', [ ]) }}" class="text-center dropdown-item">
                    <span class="text-muted text-sm">{{__("You haven't any new notifications")}}</span>
                </a>
            @endforelse
            <div class="dropdown-divider"></div>
            <a href="{{ route('dashboard.notifications.index', [ ]) }}" class="dropdown-item dropdown-footer">{{__('See All Notifications')}}</a>
        </div>
    </li>
    <li class="nav-item">
        <a class="nav-link" data-widget="control-sidebar" data-slide="true" href="#" role="button">
            <i class="fas fa-question"></i>
        </a>
    </li>
    <li class="nav-item"><a class="nav-link" href="{{ route('logout') }}" onclick="event.preventDefault();document.getElementById('logout-form').submit();"><i class="fas fa-sign-out-alt"></i></a></li>
</ul>
