@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <form class="card card-primary card-outline" method="post" action="{{route('dashboard.configuration.update')}}" id="form" data-layout="configuration">

                        <div class="card-header">
                            <h3 class="card-title">{{__('Configuration')}}</h3>
                        </div>
                        <div class="card-body">
                            @csrf
                            <nav class="languagesNav">
                                <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                                    @foreach(\Config::get('app.languages') as $language)
                                    <a class="nav-item nav-link @if($language->prefix==\Config::get('app.locale'))  active @endif " id="name_{{$language->prefix}}-tab" data-toggle="tab" href="#name_{{$language->prefix}}" role="tab" aria-controls="name_{{$language->prefix}}" aria-selected="true">{{$language->name}}</a>
                                    @endforeach
                                </div>
                            </nav>
                            <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
                                @foreach(\Config::get('app.languages') as $language)

								<div class="tab-pane fade @if($language->prefix==\Config::get('app.locale'))  show active @endif " id="name_{{$language->prefix}}" role="tabpanel" aria-labelledby="name_{{$language->prefix}}-tab">
									<div class="form-group row">
										<label for="name_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('Website Name')}} [{{$language->prefix}}]</label>
										<div class="col-sm-10">
											<input type="text" value="{{Config::get('app.name')[$language->prefix]}}" class=" form-control" id="name_{{$language->prefix}}" name="name_{{$language->prefix}}" placeholder="Enter Your Website Name ... " />
										</div>
									</div>

									<div class="form-group row">
										<label for="slogan_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('Slogan')}} [{{$language->prefix}}]</label>
										<div class="col-sm-10">
											<input type="text" value="{{ Config::get('app.slogan')[$language->prefix] }}" class=" form-control" id="slogan_{{$language->prefix}}" name="slogan_{{$language->prefix}}" placeholder="Enter Your Website Slogan ... " />
										</div>
									</div>

									<div class="form-group row">
										<label for="customer-area-title_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('customer area title')}} [{{$language->prefix}}]</label>
										<div class="col-sm-10">
											<input type="text" value="{{ Config::get('app.customer-area.title')[$language->prefix] }}" class=" form-control" id="customer-area-title_{{$language->prefix}}" name="customer-area-title_{{$language->prefix}}" placeholder="Enter customer area title ... " />
										</div>
									</div>

									<div class="form-group row">
										<label for="description_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('Description')}} [{{$language->prefix}}]</label>
										<div class="col-sm-10">
											<textarea class=" form-control" id="description_{{$language->prefix}}" name="description_{{$language->prefix}}" placeholder="Enter Your Website description ... ">{{ Config::get('app.description')[$language->prefix] }}</textarea>
										</div>
									</div>

									<div class="form-group row">
										<label for="copyright_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('Copyright')}} [{{$language->prefix}}]</label>
										<div class="col-sm-10">
											<textarea class=" form-control" id="copyright_{{$language->prefix}}" name="copyright_{{$language->prefix}}" placeholder="Enter Your Website copyright ... ">{{ Config::get('app.copyright')[$language->prefix] }}</textarea>
										</div>
									</div>


								</div>

                                @endforeach
                            </div>

                            <div class="form-group row">
                                <label for="defaultTimeZone" class="col-sm-2 col-form-label">{{__('Default Time Zone')}}</label>
                                <div class="col-sm-10">
                                    <select class="form-control select2" id="defaultTimeZone" name="defaultTimeZone">
                                        @foreach (timezone_identifiers_list() as $timezone)
                                            <option value="{{$timezone}}" @if(\Config::get('app.timezone')==$timezone) selected @endif >{{$timezone}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="itemsPerPage" class="col-sm-2 col-form-label">{{__('Items Per Page')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" value="{{old('phone',\Config::get('app.itemsPerPage'))}}" class="form-control" id="itemsPerPage" name="itemsPerPage" placeholder="Enter Items Per Page ... " />
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="featuredImage" class="col-sm-2 col-form-label">{{__('Default Featured Image')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" data-type="defaultFeaturedImage" value="{{old('phone',\Config::get('app.default.featuredImage'))}}" class="form-control" id="featuredImage" name="featuredImage" disabled />
                                    <i class="far fa-folder-open file_manger_icon"></i>
                                </div>
                            </div>

							<div class="form-group row">
                                <label for="logo" class="col-sm-2 col-form-label">{{__('Logo')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" data-type="logo" value="{{old('phone',\Config::get('app.logo.src'))}}" class="form-control" id="logo" name="logo" disabled />
                                    <i class="far fa-folder-open file_manger_icon"></i>
                                </div>
                            </div>

							<div class="form-group row">
                                <label for="logo" class="col-sm-2 col-form-label">{{__('Logo Icon')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" data-type="logo-icon" value="{{old('phone',\Config::get('app.logo.icon'))}}" class="form-control" id="logo_icon" name="logo_icon" disabled />
                                    <i class="far fa-folder-open file_manger_icon"></i>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="favicon" class="col-sm-2 col-form-label">{{__('Favicon')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" data-type="favicon" value="{{old('phone',\Config::get('app.favicon'))}}" class="form-control" id="favicon" name="favicon" disabled />
                                    <i class="far fa-folder-open file_manger_icon"></i>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="allowedExtensions" class="col-sm-2 col-form-label">{{__('Allowed File Types')}}</label>
                                <div class="col-sm-10">
                                    <select multiple data-tags="true" class="form-control select2" id="allowedExtensions" name="allowedExtensions[]">
                                        @foreach(explode(',',\Config::get('upload.allowed.extensions')) as $element)
                                        <option value="{{ $element }}" selected>{{ $element }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="maxFileSize" class="col-sm-2 col-form-label">{{__('Max. Filesize (KB)')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" value="{{old('maxFileSize',\Config::get('upload.max.filesize'))}}" class="form-control" name="maxFileSize" id="maxFileSize" />
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="theme" class="col-sm-2 col-form-label">{{__('Website Theme')}} </label>
                                <div class="col-sm-10">
                                    <select class="form-control select2" id="theme" name="theme">
                                        @foreach(glob(resource_path('views/themes/*')) as $theme)
                                            @if(is_dir($theme))
                                            <option value="{{str_replace(resource_path()."/views/themes/","",$theme)}}" @if(\Config::get('app.theme')==str_replace(resource_path()."/views/themes/","",$theme)) selected @endif >{{str_replace(resource_path()."/views/themes/","",$theme)}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="defaultLanguage" class="col-sm-2 col-form-label">{{__('Default Language')}}</label>
                                <div class="col-sm-10">
                                    <select class="form-control select2" id="defaultLanguage" name="defaultLanguage">
                                        @foreach(\Config::get('app.languages') as $language){
                                        <option value="{{$language->prefix}}" @if(\Config::get('app.fallback_locale')==$language->prefix) selected @endif >{{$language->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>


                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
                                            <input type="checkbox" class="custom-control-input form-control" id="https" name="https" @if(\Config::get('app.https')=='true') checked @endif />
                                            <label class="custom-control-label" for="https">{{__('Enable Https')}}</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="custom-control custom-switch custom-switch-off-danger custom-switch-on-success">
                                            <input type="checkbox" class="custom-control-input form-control" id="www" name="www" @if(\Config::get('app.www')=='true') checked @endif />
                                            <label class="custom-control-label" for="www">{{__('Enable www')}}</label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
							<button type="button" id="saveConfiguration" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Save')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
@endsection
