@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <form class="card card-primary card-outline" method="post" action="{{route('dashboard.configuration.update')}}" id="form" data-layout="main-nav">

                        <div class="card-header">
                            <h3 class="card-title">{{__('Configuration')}}</h3>
                        </div>
                        <div class="card-body">
                            @csrf
							<div class="dd nestable">
							    <ul class="dd-list">
									@foreach(Afrodien::mainNav() as $li)
								        <li
											class="dd-item"
											@foreach(Config::get('app.languages') as $language)
												data-title-{{$language->prefix}}="{{$li['title'][$language->prefix]}}"
											@endforeach
											data-slug="{{$li['slug']}}"
										>
								            <div class="dd-handle">
												{{$li['title'][\Config::get('app.locale')]}}
											</div>
											<span class="fas fa-trash delete-nav-item"></span>
											<span data-toggle="modal" data-target="#exampleModalLong" class="fas fa-edit edit-nav-item"></span>


											@if(!empty($li['sub']))
												<ol class="dd-list">
													@foreach($li['sub'] as $sub_li)
														<li class="dd-item"
														@foreach(Config::get('app.languages') as $language)
															data-title-{{$language->prefix}}="{{$sub_li['title'][$language->prefix]}}"
														@endforeach
														data-slug="{{$sub_li['slug']}}">
												            <div class="dd-handle">{{$sub_li['title'][\Config::get('app.locale')]}}</div>
															<span class="fas fa-trash delete-nav-item"></span>
															<span data-toggle="modal" data-target="#exampleModalLong" class="fas fa-edit edit-nav-item"></span>
											        	</li>
													@endforeach
												</ol>
											@endif

								        </li>
									@endforeach
							    </ul>
							</div>
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
							<button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#exampleModal">
							  {{__('Add item')}}
							</button>
							<button type="button" id="saveConfiguration" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Save')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

	<!-- Modal -->
	<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	    <div class="modal-dialog" role="document">
	        <div class="modal-content">
	            <div class="modal-header">
	                <h5 class="modal-title" id="exampleModalLabel">{{__('Add item')}}</h5>
	                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
	                    <span aria-hidden="true">&times;</span>
	                </button>
	            </div>
	            <div class="modal-body">

					<div class="form-group row">
						<label for="slug" class="col-sm-2 col-form-label">{{__('Slug')}}</label>
						<div class="col-sm-10">
							<input type="text" class=" form-control" id="slug" name="slug" placeholder="{{__('Enter Your Slug')}} ... " />
						</div>
					</div>

	                @foreach(Config::get('app.languages') as $language)
						<div class="form-group row">
							<label for="title_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('title')}} [{{$language->prefix}}]</label>
							<div class="col-sm-10">
								<input type="text" class=" form-control" id="title_{{$language->prefix}}" name="title_{{$language->prefix}}" placeholder="{{__('Enter item title')}} ... " />
							</div>
						</div>
					@endforeach

	            </div>
	            <div class="modal-footer">
	                <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('Close')}}</button>
	                <button type="button" id="AddItem" data-dismiss="modal" class="btn btn-primary">{{__('Save changes')}}</button>
	            </div>
	        </div>
	    </div>
	</div>


	<!-- Modal -->
	<div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
	    <div class="modal-dialog" role="document">
	        <form class="modal-content">
	            <div class="modal-header">
	                <h5 class="modal-title" id="exampleModalLongTitle">Edit Nav item</h5>
	                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
	                    <span aria-hidden="true">&times;</span>
	                </button>
	            </div>
	            <div class="modal-body">
					<div class="form-group">
						<label for="NavItemSlug">Slug</label>
						<input type="text" class="form-control" id="NavItemSlug" placeholder="Slug" />
					</div>

					@foreach(Config::get('app.languages') as $language)
						<div class="form-group">
							<label for="NavItemTitle_{{$language->prefix}}">Title [{{$language->prefix}}]</label>
							<input type="text" class="form-control" id="NavItemTitle_{{$language->prefix}}" placeholder="Title [{{$language->prefix}}]" />
						</div>
					@endforeach
				</div>
	            <div class="modal-footer">
	                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
	                <button type="button" class="btn btn-primary" id="UpdateNavItem" data-dismiss="modal">Save changes</button>
	            </div>
	        </form>
	    </div>
	</div>


@endsection
