@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <form class="card card-primary card-outline" method="post" action="{{route('dashboard.configuration.update')}}" id="form" data-layout="social-media">

                        <div class="card-header">
                            <h3 class="card-title">{{__('Configuration')}}</h3>
                        </div>
                        <div class="card-body">
                            @csrf

							<div class="form-group row">
								<label for="facebook-app" class="col-sm-2 col-form-label">{{__('Facebook App ID')}}</label>
								<div class="col-sm-10">
									<input type="text" value="{{old('facebook-app',\Config::get('app.social.facebook.app'))}}" class="form-control" id="facebook-app" name="facebook-app" placeholder="{{__('Enter Your Facebook App ID')}}" />
								</div>
							</div>

							<div class="form-group row">
                                <label for="facebook" class="col-sm-2 col-form-label">{{__('Facebook Page ID')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" value="{{old('facebook',\Config::get('app.social.facebook.page'))}}" class="form-control" id="facebook" name="facebook" placeholder="{{__('Enter Your Facebook Page ID')}}" />
                                </div>
                            </div>

							<div class="form-group row">
                                <label for="twitter" class="col-sm-2 col-form-label">{{__('Twitter ID')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" value="{{old('twitter',\Config::get('app.social.twitter'))}}" class="form-control" id="twitter" name="twitter" placeholder="{{__('Enter Your Twitter ID')}}" />
                                </div>
                            </div>

							<div class="form-group row">
                                <label for="instagram" class="col-sm-2 col-form-label">{{__('Instagram ID')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" value="{{old('instagram',\Config::get('app.social.instagram'))}}" class="form-control" id="instagram" name="instagram" placeholder="{{__('Enter Your instagram ID')}}" />
                                </div>
                            </div>

							<div class="form-group row">
                                <label for="linkedin" class="col-sm-2 col-form-label">{{__('LinkedIn ID')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" value="{{old('linkedin',\Config::get('app.social.linkedin'))}}" class="form-control" id="linkedin" name="linkedin" placeholder="{{__('Enter Your linkedin ID')}}" />
                                </div>
                            </div>

                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
							<button type="button" id="saveConfiguration" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Save')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
@endsection
