@extends('dashboard.layout')

@section('content')

	@php
	$Date = date('Y-m-d',strtotime("-1 month"));

	$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors`  WHERE `visitors`.`browser`='Safari' and `visitors`.`robot`='0' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
	$Safari = $row[0]->Counter;

	$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors`  WHERE `visitors`.`browser`='Firefox' and `visitors`.`robot`='0' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
	$FireFox = $row[0]->Counter;

	$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors`  WHERE `visitors`.`browser`='Chrome' and `visitors`.`robot`='0' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
	$Chrome = $row[0]->Counter;

	$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors`  WHERE `visitors`.`browser`='Opera' and `visitors`.`robot`='0' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
	$Opera = $row[0]->Counter;

	$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors`  WHERE `visitors`.`browser`='Edge' and `visitors`.`robot`='0' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
	$Edge = $row[0]->Counter;
	/*<!--------------------------------------------------------------------------------------
	Start System -------------------------------------------------------------------------->*/

	$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors`  WHERE `visitors`.`platform` = 'Windows' and `visitors`.`robot`='0' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
	$Windows = $row[0]->Counter;

	$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors`  WHERE ( `visitors`.`platform` = 'Ubuntu' or `visitors`.`platform` = 'Linux' ) and `visitors`.`robot`='0' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
	$Linux = $row[0]->Counter;

	$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors`  WHERE `visitors`.`platform`='OS X' and `visitors`.`robot`='0' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
	$Mac = $row[0]->Counter;

	$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors`  WHERE `visitors`.`platform`='AndroidOS' and `visitors`.`robot`='0' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
	$Android = $row[0]->Counter;

	$row = \DB::select("SELECT count(*) as `Counter` FROM `visitors`  WHERE `visitors`.`platform`='IOS' and `visitors`.`robot`='0' and DATE(`visitors`.`created_at`) > ? ",[$Date]);
	$IOS = $row[0]->Counter;

	@endphp

	<section class="content">
	    <div class="container-fluid">
	        <div class="row">
	            <div class="col-lg-3 col-6">
	                <!-- small box -->
	                <div class="small-box bg-info">
	                    <div class="inner">
							<h3>{{DB::table('newsletter_subscribers')->whereDate('created_at', '>=', date('Y-m-d H:i:s',strtotime('-30 days')) )->count()}}</h3>

	                        <p>{{__('newsletter subscribers')}}</p>
	                    </div>
	                    <div class="icon">
	                        <i class="fas fa-paper-plane"></i>
	                    </div>
	                    <a href="{{route('dashboard.newsletter.index')}}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
	                </div>
	            </div>
	            <!-- ./col -->
	            <div class="col-lg-3 col-6">
	                <!-- small box -->
	                <div class="small-box bg-success">
	                    <div class="inner">
							<h3>{{DB::table('notifications_subscribers')->whereDate('created_at', '>=', date('Y-m-d H:i:s',strtotime('-30 days')) )->count()}}</h3>

	                        <p>{{__('notifications subscribers')}}</p>
	                    </div>
	                    <div class="icon">
	                        <i class="fas fa-bell"></i>
	                    </div>
	                    <a href="{{route('dashboard.push-notification.index')}}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
	                </div>
	            </div>
	            <!-- ./col -->
	            <div class="col-lg-3 col-6">
	                <!-- small box -->
	                <div class="small-box bg-warning">
	                    <div class="inner">
	                        <h3>{{App\User::whereDate('created_at', '>=', date('Y-m-d H:i:s',strtotime('-30 days')) )->count()}}</h3>

	                        <p>{{__('User Registrations')}}</p>
	                    </div>
	                    <div class="icon">
	                        <i class="fas fa-user-plus"></i>
	                    </div>
	                    <a href="{{route('dashboard.virtual-system.index',['page_slug'=>'users'])}}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
	                </div>
	            </div>
	            <!-- ./col -->
	            <div class="col-lg-3 col-6">
	                <!-- small box -->
	                <div class="small-box bg-danger">
	                    <div class="inner">
	                        <h3>{{DB::table('visitors')->where('robot','=','0')->whereDate('created_at', '>=', date('Y-m-d H:i:s',strtotime('-30 days')) )->count()}}</h3>

	                        <p>{{__('Unique Visitors')}}</p>
	                    </div>
	                    <div class="icon">
	                        <i class="fas fa-users"></i>
	                    </div>
	                    <a href="{{route('dashboard.virtual-system.index',['page_slug'=>'visitors'])}}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
	                </div>
	            </div>
	            <!-- ./col -->
	        </div>

	        <div class="row">
	            <div class="col-lg-4">
	                <div class="card">
	                    <div class="card-header">
	                        <h3 class="card-title">{{__('latest posts')}}</h3>
							<div class="card-tools">
	                            <span class="badge badge-danger">{{App\Post::whereDate('created_at', '>=', date('Y-m-d H:i:s',strtotime('-30 days')) )->count()}} {{__('New Post')}}</span>
	                        </div>
	                    </div>
	                    <!-- /.card-header -->
	                    <div class="card-body p-0">
	                        <ul class="products-list product-list-in-card pl-2 pr-2">
								@forelse (\App\Post::latest()->limit(10)->get() as $post)
									@php
										$post->structure();
									@endphp
	                            <li class="item">
	                                <div class="product-img">
	                                    <img src="{{$post->thumbnail['src']}}" alt="{{$post->title}}" class="img-size-50" />
	                                </div>
	                                <div class="product-info">
	                                    <a href="{{route('dashboard.virtual-system.edit',['page_slug'=>'posts','record_id'=>$post->post_id])}}" class="product-title">{{$post->title}} <span class="badge @if($post->post_status=='published') badge-success @else badge-warning @endif float-right">{{__($post->post_status)}}</span></a>
	                                    <span class="product-description">
	                                        {{$post->description}}
	                                    </span>
	                                </div>
	                            </li>
								@empty
									<li class="item text-center">
									   {{__('you have not added any post yet')}}
								   </li>
								@endforelse
	                        </ul>
	                    </div>
	                    <!-- /.card-body -->
	                    <div class="card-footer text-center">
	                        <a href="{{route('dashboard.virtual-system.index',['page_slug'=>'posts'])}}" class="uppercase">{{__('View All Posts')}}</a>
	                    </div>
	                    <!-- /.card-footer -->
	                </div>

	                <div class="card">
	                    <div class="card-header">
	                        <h3 class="card-title">{{__('Latest Members')}}</h3>

	                        <div class="card-tools">
	                            <span class="badge badge-danger">{{App\User::whereDate('created_at', '>=', date('Y-m-d H:i:s',strtotime('-30 days')) )->count()}} {{__('New Members')}}</span>
	                        </div>
	                    </div>
	                    <!-- /.card-header -->
	                    <div class="card-body p-0">
	                        <ul class="users-list clearfix">
								@foreach (\App\User::latest()->limit(12)->get() as $user)
	                            <li>
	                                <img src="{{$user->avatar()}}" alt="User Image" />
	                                <a class="users-list-name" href="{{route('dashboard.virtual-system.edit',['page_slug'=>'users', 'record_id'=>$user->id])}}">{{$user->name}}</a>
	                                <span class="users-list-date">{{$user->created_at->diffForHumans()}}</span>
	                            </li>
								@endforeach
	                        </ul>
	                        <!-- /.users-list -->
	                    </div>
	                    <!-- /.card-body -->
	                    <div class="card-footer text-center">
	                        <a href="{{route('dashboard.virtual-system.index',['page_slug'=>'users'])}}">{{__('View All Users')}}</a>
	                    </div>
	                    <!-- /.card-footer -->
	                </div>

					<div class="card">
	                    <div class="card-header">
	                        <h3 class="card-title">{{__('Browser Usage')}}</h3>
	                    </div>
	                    <!-- /.card-header -->
	                    <div class="card-body">
	                        <div class="row">
	                            <div class="col-md-12">
	                                <div class="chart-responsive">
	                                    <div class="chartjs-size-monitor">
	                                        <div class="chartjs-size-monitor-expand"><div class=""></div></div>
	                                        <div class="chartjs-size-monitor-shrink"><div class=""></div></div>
	                                    </div>
	                                    <canvas id="pieChart" height="102" width="204" class="chartjs-render-monitor" style="display: block; width: 204px; height: 102px;"></canvas>
	                                </div>
	                                <!-- ./chart-responsive -->
	                            </div>

	                            <!-- /.col -->
	                        </div>
	                        <!-- /.row -->
							<script type="text/javascript">
				                var pieChart = {
							        labels: ['{{__('Chrome')}}', '{{__('FireFox')}}', '{{__('Safari')}}', '{{__('Opera')}}', '{{__('Edge')}}'],
							        datasets: [{
							            label: '',
							            data: [{{ $Chrome }},
										{{ $FireFox}},
										{{ $Safari }},
										{{ $Opera }},
										{{ $Edge }} ],
							            backgroundColor: [
											"#f56954",
				                            "#f39c12",
				                            "#00c0ef",
				                            "#3c8dbc",
				                            "#d2d6de"
							            ]
							        }]
							    };
								$("#pieChart").attr("data-obj",JSON.stringify(pieChart));
							</script>
	                    </div>

	                    <!-- /.card-body -->
	                    <div class="card-footer bg-white p-0">
	                        <ul class="nav nav-pills flex-column">
								<!-- /.card-body -->
			                    <div class="card-footer bg-white p-0">
			                        <ul class="nav nav-pills flex-column">
										@foreach (\DB::select("SELECT `browser` , count(`id`) as `counter` FROM `visitors` where `visitors`.`robot`='0' GROUP BY `browser` order by `counter` DESC ") as $browser)
											@if(trim($browser->browser)!=="0")
				                            <li class="nav-item">
				                                <a href="{{route('dashboard.virtual-system.index',['page_slug'=>'visitors','browser'=>$browser->browser])}}" class="nav-link">
													{{__($browser->browser)}}
				                                    <span class="float-not-as-lang text-success">
														{{$browser->counter}}
				                                    </span>
				                                </a>
				                            </li>
										@endif
										@endforeach
			                        </ul>
			                    </div>
			                    <!-- /.footer -->
	                        </ul>
	                    </div>
	                    <!-- /.footer -->
	                </div>


					<div class="card">
						<div class="card-header">
							<h3 class="card-title">{{__('Platform Usage')}}</h3>
						</div>
						<!-- /.card-header -->
						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									<div class="chart-responsive">
										<div class="chartjs-size-monitor">
											<div class="chartjs-size-monitor-expand"><div class=""></div></div>
											<div class="chartjs-size-monitor-shrink"><div class=""></div></div>
										</div>
										<canvas id="pieChart2" height="102" width="204" class="chartjs-render-monitor" style="display: block; width: 204px; height: 102px;"></canvas>
									</div>
									<!-- ./chart-responsive -->
								</div>

								<!-- /.col -->
							</div>
							<!-- /.row -->
							<script type="text/javascript">
								var pieChart2 = {
									labels: [
										"{{__('Windows')}}",
										"{{__('Linux & Ubuntu')}}",
										"{{__('Mac')}}",
										"{{__('Android')}}",
										"{{__('IOS')}}"
									],
									datasets: [{
										data: [
											{{ $Windows }},
											{{ $Linux }},
											{{ $Mac }},
											{{ $Android }},
											{{ $IOS }}
										],
										backgroundColor: [
											"#f56954",
											"#00a65a",
											"#f39c12",
											"#00c0ef",
											"#3c8dbc"
										],
									}]
								};
								$("#pieChart2").attr("data-obj",JSON.stringify(pieChart2));
							</script>
						</div>

						<!-- /.card-body -->
	                    <div class="card-footer bg-white p-0">
	                        <ul class="nav nav-pills flex-column">
								@foreach (\DB::select("SELECT `platform` , count(`id`) as `counter` FROM `visitors` where `visitors`.`robot`='0' GROUP BY `platform` order by `counter` DESC ") as $platform)
									@if(trim($platform->platform)!=="0")
									<li class="nav-item">
										<a href="{{route('dashboard.virtual-system.index',['page_slug'=>'visitors','platform'=>$platform->platform])}}" class="nav-link">
											{{__($platform->platform)}}
											<span class="float-not-as-lang text-success">
												{{$platform->counter}}
											</span>
										</a>
									</li>
									@endif
								@endforeach
	                        </ul>
	                    </div>
	                    <!-- /.footer -->
	                </div>
	            </div>
	            <div class="col-lg-8">
	                <div class="card">
	                    <div class="card-header">
	                        <div class="d-flex justify-content-between">
	                            <h3 class="card-title">{{__('Visitors')}}</h3>
	                        </div>
	                    </div>
	                    <div class="card-body">
	                        <div class="d-flex">
	                            <p class="d-flex flex-column">
	                                <span class="text-bold text-lg">{{DB::table('visitors')->whereDate('created_at', '>=', date('Y-m-d H:i:s',strtotime('-30 days')) )->where('robot','=','0')->count()}}</span>
	                                <span>{{__('Visitors')}} ({{__('Last 30 Days')}})</span>
	                            </p>

	                            <p class="ml-auto d-flex flex-column text-right">
	                                <span class="text-success"> <i class="fas fa-arrow-up"></i> {{ $percentage }}% </span>
	                                <span class="text-muted">{{__('Since last week')}}</span>
	                            </p>
	                        </div>
	                        <!-- /.d-flex -->

	                        <div class="position-relative mb-4">
	                            <canvas id="visitors-chart" height="200" data-dayOfWeek='{!! $dayOfWeek !!}' data-list1='{!! $list1 !!}' data-list2='{!! $list2 !!}' ></canvas>
	                        </div>

	                        <div class="d-flex flex-row justify-content-end">
	                            <span class="mr-2 ml-2"> <i class="fas fa-square text-primary"></i> {{__('This Week')}} </span>

	                            <span> <i class="fas fa-square text-gray"></i> {{__('Last Week')}} </span>
	                        </div>
	                    </div>
	                </div>


					<div class="card card-primary card-outline">
						<div class="card-header">
							<h3 class="card-title">{{__('Recent Activities')}}</h3>
						</div>
						<div class="card-body">
							<div class="timeline timeline-inverse">
								@foreach (\UserActivity::list(10) as $activity)
									<div>
										<i class="icon bg-gray"></i>
										<div class="timeline-item">
											<span class="time"><i class="far fa-clock"></i> {{$activity->created_at->diffForHumans()}} </span>
											<h3 class="timeline-header border-0">{{$activity->name}} - {{$activity->body}}</h3>
										</div>
									</div>
								@endforeach
							</div>
						</div>
						<!-- /.card-body -->
					</div>

					<div class="card">
						<div class="card-header ui-sortable-handle" style="cursor: move;">
							<h3 class="card-title">
								<i class="ion ion-clipboard mr-1"></i>
								{{__('To Do List')}}
							</h3>
						</div>
						<!-- /.card-header -->
						<div class="card-body">
							<ul class="todo-list ui-sortable" data-widget="todo-list">
								@forelse (DB::table('to_do_list')->where('user_id',\auth::user()->id)->limit(10)->get() as $task)
									<li>
										<span class="text">{{$task->body}}</span>
										<small class="badge badge-success"><i class="far fa-clock"></i> {{$task->status}}</small>
										<div class="tools">
											<i class="fas fa-edit"></i>
											<i class="fas fa-trash-o"></i>
										</div>
									</li>
								@empty
									<li>
										<span class="text">{{__('you do not have any tasks')}}</span>
									</li>
								@endforelse
							</ul>
						</div>
						<!-- /.card-body -->
						<div class="card-footer clearfix">
							<a type="button" href="{{route('dashboard.virtual-system.create',['page_slug'=>'to-do-list'])}}" class="btn btn-info float-not-as-lang"><i class="fas fa-plus"></i> {{__('Add item')}}</a>
						</div>
					</div>

	                <!-- /.card -->
	            </div>
	        </div>
	    </div>
	</section>

@endsection
