@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <form class="card card-primary card-outline" id="form" method="post" action="{{ route('dashboard.configuration.languages.update' ) }}">

                        <div class="card-header">
                            <h3 class="card-title">{{__('Edit Language')}}</h3>
                        </div>
                        <div class="card-body">

                            @csrf


							<nav class="languagesNav">
                                <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                                    @foreach(\Config::get('app.languages') as $language)
                                    <a class="nav-item nav-link @if($language->prefix==\Config::get('app.locale'))  active @endif " id="name_{{$language->prefix}}-tab" data-toggle="tab" href="#name_{{$language->prefix}}" role="tab" aria-controls="name_{{$language->prefix}}" aria-selected="true">{{$language->name}}</a>
                                    @endforeach
                                </div>
                            </nav>

							<div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
								@foreach(\Config::get('app.languages') as $language)
									@php
										$content = file_get_contents("../resources/lang/".$language->prefix.".json");
										$content = json_decode($content,true);
									@endphp

									<div class="tab-pane fade @if($language->prefix==\Config::get('app.locale'))  show active @endif " id="name_{{$language->prefix}}" role="tabpanel" aria-labelledby="name_{{$language->prefix}}-tab">
										@foreach ($content as $key => $value)
				                            <div class="form-group row">
				                                <label class="col-sm-2 col-form-label" for="{{$key}}_{{$language->prefix}}">{{$key}}</label>
												<div class="col-sm-10">
													<input type="text" class="form-control {{$language->prefix}}" id="{{$key}}_{{$language->prefix}}" name="{{$key}}" placeholder="{{__('Enter trans')}} ..." value="{{$value}}" />
				                            	</div>
				                            </div>
										@endforeach
									</div>
								@endforeach
							</div>

                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
							<button type="button" data-toggle="modal" data-target="#exampleModal" class="btn btn-sm btn-info"><i class="fa fa-plus"></i> {{__('Add item')}}</button>
							<button type="button" id="update-languages" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Update')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

	<!-- Modal -->
	<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	  <div class="modal-dialog" role="document">
	    <div class="modal-content">
	      <div class="modal-header">
	        <h5 class="modal-title" id="exampleModalLabel">{{__('Add New item')}}</h5>
	        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
	          <span aria-hidden="true">&times;</span>
	        </button>
	      </div>
	      <div class="modal-body">

				<form id="new-item" method="post" action="{{route('dashboard.configuration.languages.store')}}">
					<div class="form-group row">
						<label class="col-sm-2 col-form-label" for="lang-key">{{__('key')}}</label>
						<div class="col-sm-10">
							<input type="text" class="form-control" id="lang-key" name="key" placeholder="{{__('Enter trans key')}} ..." />
						</div>
					</div>

					<nav class="languagesNav">
	                    <div class="nav nav-tabs nav-fill" role="tablist">
	                        @foreach(\Config::get('app.languages') as $language)
	                        <a class="nav-item nav-link @if($language->prefix==\Config::get('app.locale'))  active @endif " id="new_item_{{$language->prefix}}-tab" data-toggle="tab" href="#new_item_{{$language->prefix}}" role="tab" aria-controls="new_item_{{$language->prefix}}" aria-selected="true">{{$language->name}}</a>
	                        @endforeach
	                    </div>
	                </nav>

					<div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
						@foreach(\Config::get('app.languages') as $language)
							<div class="tab-pane fade @if($language->prefix==\Config::get('app.locale'))  show active @endif " id="new_item_{{$language->prefix}}" role="tabpanel" aria-labelledby="new_item_{{$language->prefix}}-tab">
		                        <div class="form-group row">
		                            <label class="col-sm-2 col-form-label" for="value">{{__('value')}}</label>
									<div class="col-sm-10">
										<input type="text" class="form-control {{$language->prefix}}" id="value_{{$language->prefix}}" name="value" placeholder="{{__('Enter trans')}} ..." />
		                        	</div>
		                        </div>
							</div>
						@endforeach
					</div>
				</form>
	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('Close')}}</button>
	        <button type="button" class="btn btn-primary" id="add-language-item"><i class="fa fa-check"></i> {{__('Add')}}</button>
	      </div>
	    </div>
	  </div>
	</div>
@endsection
