<!DOCTYPE html>
<html lang="{{Config::get('app.locale')}}">

    <head>

        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">

        <title>{{ config('app.name')[Config::get('app.locale')] . " | " . $title }}</title>

        <!-- Tell the browser to be responsive to screen width -->
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- Font Awesome -->
        <link rel="stylesheet" href="{{ asset("/plugins/fontawesome-free/css/all.min.css") }}">

        <!-- overlayScrollbars -->
        <link rel="stylesheet" href="{{ asset("/plugins/adminlte/css/adminlte.min.css") }}">

        <!-- Google Font: Source Sans Pro -->
        <link rel="stylesheet" href="{{ asset("/plugins/toastr/toastr.min.css") }}">

        <!-- Google Font: Source Sans Pro -->
        <link rel="stylesheet" href="{{ asset("/plugins/select2/css/select2.min.css") }}">

        <link rel="stylesheet" href="{{ asset("/plugins/summernote/summernote-bs4.min.css") }}">

        <link rel="stylesheet" href="{{ asset("/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css") }}" />
        <link rel="stylesheet" href="{{ asset("/plugins/datatables-buttons/css/buttons.bootstrap4.min.css") }}" />

        <!-- Google Font: Source Sans Pro -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <!-- Google Font: Source Sans Pro -->
        <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

        <link rel="stylesheet" href="{{ asset("/plugins/afrodien/css/dashboard.app.css") }}">

        <!-- jQuery -->
        <script src="{{ asset("/plugins/jquery/jquery.min.js") }}"></script>

        <script>
			var languages = {!! json_encode(Config::get('app.languages')) !!};
        </script>

		<link rel="shortcut icon" href="{{url('/storage/'.config('app.favicon'))}}">

		<base href="{{url('')}}" />
		<meta name="home" content="{{route('frontend.index')}}" />

		@if( json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['dir']=="rtl")
        <link rel="stylesheet" href="{{ asset("/plugins/afrodien/css/dashboard.app.rtl.css") }}">
        @endif

		@if( json_decode(json_encode(Config::get('app.languages')), true)[Config::get('app.locale')]['prefix']=="ar")
		<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300&display=swap" rel="stylesheet">
		@endif

		<style media="screen">
			body{
				background: #f4f6f9;
			}
			.nav-tabs{
				border: 0;
			}
		</style>

    </head>

    <body class="hold-transition sidebar-mini" data-type="{{\request('type')}}">
        <div class="wrapper">
            <div class="container">
				@if(\request('type')=="multimedia")
					<button type="button" class="btn btn-sm btn-primary" id="select-multi-media" name="button">Select</button>
					<div id="tabs">
	                    <nav>
	                        <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
	                            <a class="nav-item nav-link active" id="nav-upload-tab" data-toggle="tab" href="#nav-upload" role="tab" aria-controls="nav-upload" aria-selected="true">{{__('Upload')}}</a>
	                            <a class="nav-item nav-link" id="nav-my-media-tab" data-toggle="tab" href="#nav-my-media" role="tab" aria-controls="nav-my-media" aria-selected="false">{{__('My Media')}}</a>
	                            <a class="nav-item nav-link" id="nav-all-tab" data-toggle="tab" href="#nav-all" role="tab" aria-controls="nav-all" aria-selected="false">{{__('All Media')}}</a>
	                        </div>
	                    </nav>
	                    <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
	                        <div class="tab-pane fade show active" id="nav-upload" role="tabpanel" aria-labelledby="nav-upload-tab">
	                            <form method="post" action="{{ route('dashboard.media.upload') }}" data-type="{{\request('type')}}" enctype="multipart/form-data" id="UploadForm">
	                                <input type="file" name="file" id="file" />
	                                <div class="upload-area" id="uploadfile">
	                                    <h1>
	                                        {{__('Drag and Drop file here')}}<br />
	                                        {{__('Or')}}<br />
	                                        {{__('Click to select file')}}
	                                    </h1>
	                                </div>
	                                <div id="files" class="row"></div>
	                            </form>
	                        </div>
	                        <div class="tab-pane fade" id="nav-my-media" role="tabpanel" aria-labelledby="nav-my-media-tab">
								<div class="container-fluid">
									<div class="row">
										@forelse (\App\Media::where('created_by',Auth::id())->latest()->paginate(12) as $media)
										    <div class="thumbnail col-md-3" data-img="{{$media->name}}" data-id="{{$media->id}}"
												data-extension="{{$media['extension']}}"
											@foreach(Config::get('app.languages') as $language)
												data-title-{{$language->prefix}}="{{$media['title_'.$language->prefix]}}"
												data-alt-{{$language->prefix}}="{{$media['alt_'.$language->prefix]}}"
											@endforeach
											>
												@if($media->extension=='mp4')
													<video width='320' height='240' controls> <source src='{{asset('/storage/images/original/'.$media->name)}}' type='video/mp4'> Your browser does not support the video tag. </video>
												@else
													<img src="{{asset('storage/images/thumbnail/300/'.$media->name.'.webp')}}" />
												@endif
												<i class="fas fa-check-square select_multimedia"></i>
												<i class="fas fa-pen-square edit_media" data-toggle="modal" data-target="#exampleModal"></i>
											</div>
										@empty
											<div class="col-md-12 text-center">
												{{__('sorry, no files uploaded yet.')}}
											</div>
										@endforelse
									</div>
									<div class="text-center">
										<br>
										<button type="button" data-page="1" data-type="user" data-url="{{route('dashboard.media.load-more')}}" class="btn btn-success LoadMoreMedia" name="button">{{__('Load More')}} <i class="fa fa-chevron-circle-down"></i></button>
									</div>
								</div>
	                        </div>
	                        <div class="tab-pane fade" id="nav-all" role="tabpanel" aria-labelledby="nav-all-tab">
								<div class="container-fluid">
		                            <div class="row">
										@forelse (\App\Media::latest()->paginate(12) as $media)
											<div class="thumbnail col-md-3" data-img="{{$media->name}}" data-id="{{$media->id}}"
												@foreach(Config::get('app.languages') as $language)
													data-title-{{$language->prefix}}="{{$media['title_'.$language->prefix]}}"
													data-alt-{{$language->prefix}}="{{$media['alt_'.$language->prefix]}}"
												@endforeach
												>
												@if($media->extension=='mp4')
													<video width='320' height='240' controls> <source src='{{asset('/storage/images/original/'.$media->name)}}' type='video/mp4'> Your browser does not support the video tag. </video>
												@else
													<img src="{{asset('storage/images/thumbnail/300/'.$media->name.'.webp')}}" />
												@endif
												<i class="fas fa-check-square select_file"></i>
												<i class="fas fa-pen-square edit_media" data-toggle="modal" data-target="#exampleModal"></i>
											</div>
										@empty
											<div class="col-md-12 text-center">
												{{__('sorry, no files uploaded yet.')}}
											</div>
										@endforelse
									</div>
									<div class="text-center">
										<br>
										<button type="button" data-page="1" data-type="all" data-url="{{route('dashboard.media.load-more')}}" class="btn btn-success LoadMoreMedia" name="button">{{__('Load More')}} <i class="fa fa-chevron-circle-down"></i></button>
									</div>
								</div>
	                        </div>
	                    </div>
	                </div>
				@elseif(\request('type')=='image' || \request('type')=="image-editor")
	                <div id="tabs">
	                    <nav>
	                        <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
	                            <a class="nav-item nav-link active" id="nav-upload-tab" data-toggle="tab" href="#nav-upload" role="tab" aria-controls="nav-upload" aria-selected="true">{{__('Upload')}}</a>
	                            <a class="nav-item nav-link" id="nav-my-media-tab" data-toggle="tab" href="#nav-my-media" role="tab" aria-controls="nav-my-media" aria-selected="false">{{__('My Media')}}</a>
	                            <a class="nav-item nav-link" id="nav-all-tab" data-toggle="tab" href="#nav-all" role="tab" aria-controls="nav-all" aria-selected="false">{{__('All Media')}}</a>
	                        </div>
	                    </nav>
	                    <div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
	                        <div class="tab-pane fade show active" id="nav-upload" role="tabpanel" aria-labelledby="nav-upload-tab">
	                            <form method="post" action="{{ route('dashboard.media.upload') }}" data-type="{{\request('type')}}" enctype="multipart/form-data" id="UploadForm">
	                                <input type="file" name="file" id="file" />
	                                <div class="upload-area" id="uploadfile">
	                                    <h1>
	                                        {{__('Drag and Drop file here')}}<br />
	                                        {{__('Or')}}<br />
	                                        {{__('Click to select file')}}
	                                    </h1>
	                                </div>
	                                <div id="files" class="row"></div>
	                            </form>
	                        </div>
	                        <div class="tab-pane fade" id="nav-my-media" role="tabpanel" aria-labelledby="nav-my-media-tab">
								<div class="container-fluid">
									<div class="row">
										@forelse (\App\Media::latest()->where('created_by',Auth::id())->paginate(12) as $media)
										    <div class="thumbnail col-md-3" data-img="{{$media->name}}" data-id="{{$media->id}}"
												@foreach(Config::get('app.languages') as $language)
													data-title-{{$language->prefix}}="{{$media['title_'.$language->prefix]}}"
													data-alt-{{$language->prefix}}="{{$media['alt_'.$language->prefix]}}"
												@endforeach
												>
												@if($media->extension=='mp4')
													<video width='320' height='240' controls> <source src='{{asset('/storage/images/original/'.$media->name)}}' type='video/mp4'> Your browser does not support the video tag. </video>
												@else
													<img src="{{asset('storage/images/thumbnail/300/'.$media->name.'.webp')}}" />
												@endif
												<i class="fas fa-check-square select_file"></i>
												<i class="fas fa-pen-square edit_media" data-toggle="modal" data-target="#exampleModal"></i>
											</div>
										@empty
											<div class="col-md-12 text-center">
												{{__('sorry, no files uploaded yet.')}}
											</div>
										@endforelse
									</div>
									<div class="text-center">
										<br>
										<button type="button" data-page="1" data-type="user" data-url="{{route('dashboard.media.load-more')}}" class="btn btn-success LoadMoreMedia" name="button">{{__('Load More')}} <i class="fa fa-chevron-circle-down"></i></button>
									</div>
								</div>
	                        </div>
	                        <div class="tab-pane fade" id="nav-all" role="tabpanel" aria-labelledby="nav-all-tab">
								<div class="container-fluid">
		                            <div class="row">
										@forelse (\App\Media::latest()->paginate(12) as $media)
											<div class="thumbnail col-md-3" data-img="{{$media->name}}" data-id="{{$media->id}}"
												@foreach(Config::get('app.languages') as $language)
													data-title-{{$language->prefix}}="{{$media['title_'.$language->prefix]}}"
													data-alt-{{$language->prefix}}="{{$media['alt_'.$language->prefix]}}"
												@endforeach
											>
												@if($media->extension=='mp4')
													<video width='320' height='240' controls> <source src='{{asset('/storage/images/original/'.$media->name)}}' type='video/mp4'> Your browser does not support the video tag. </video>
												@else
													<img src="{{asset('storage/images/thumbnail/300/'.$media->name.'.webp')}}" />
												@endif
												<i class="fas fa-check-square select_file"></i>
												<i class="fas fa-pen-square edit_media" data-toggle="modal" data-target="#exampleModal"></i>
											</div>
										@empty
											<div class="col-md-12 text-center">
												{{__('sorry, no files uploaded yet.')}}
											</div>
										@endforelse
									</div>
									<div class="text-center">
										<br>
										<button type="button" data-page="1" data-type="all" data-url="{{route('dashboard.media.load-more')}}" class="btn btn-success LoadMoreMedia" name="button">{{__('Load More')}} <i class="fa fa-chevron-circle-down"></i></button>
									</div>
								</div>
	                        </div>
	                    </div>
	                </div>
				@else
					<form method="post" action="{{ route('dashboard.media.upload') }}" data-type="{{\request('type')}}" enctype="multipart/form-data" id="UploadForm">
						<input type="file" name="file" id="file" />
						<div class="upload-area" id="uploadfile">
							@if(\request('type')=='avatar')
								<h1>
									{{__('Drag and Drop Photo here')}}<br />
									{{__('Or')}}<br />
									{{__('Click to select Photo')}}
								</h1>
							@elseif(\request('type')=='defaultFeaturedImage')
								<h1>
									{{__('Drag and Drop Photo here')}}<br />
									{{__('Or')}}<br />
									{{__('Click to select Photo')}}
								</h1>
							@elseif(\request('type')=='favicon')
								<h1>
									{{__('Drag and Drop your icon here')}}<br />
									{{__('Or')}}<br />
									{{__('Click to select icon')}}
								</h1>
							@elseif(\request('type')=='logo-icon')
								<h1>
									{{__('Drag and Drop logo here')}}<br />
									{{__('Or')}}<br />
									{{__('Click to select logo')}}
								</h1>
							@elseif(\request('type')=='pdf' || \request('type')=='pdf-editor')
								<h1>
									{{__('Drag and Drop PDF File here')}}<br />
									{{__('Or')}}<br />
									{{__('Click to select PDF File')}}
								</h1>
							@elseif(\request('type')=='logo')
								<h1>
									{{__('Drag and Drop logo here')}}<br />
									{{__('Or')}}<br />
									{{__('Click to select logo')}}
								</h1>
							@endif
						</div>
						<div id="files" class="row"></div>
					</form>
				@endif
            </div>
        </div>


		<!-- Modal -->
		<div class="modal fade bd-example-modal-lg" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<form class="modal-content" id="MediaForm" action="{{route('dashboard.media.update')}}">
					<div class="modal-header">
						<h5 class="modal-title" id="exampleModalLabel">Edit Media details</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
					</div>

					<div class="modal-body" >

						<div class="form-group row">
							<label for="media_name" class="col-sm-2 col-form-label">{{__('name')}}</label>
							<div class="col-sm-10">
								<input type="text" class="form-control" id="media_name" name="media_name" placeholder="{{__('Enter Image name')}} ... " />
							</div>
						</div>
						<input type="text" class="form-control" id="media_id" name="media_id" hidden />

						<nav class="languagesNav">
							<div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
								@foreach(Config::get('app.languages') as $language)
									<a class="nav-item nav-link @if(Config::get('app.locale')==$language->prefix) active @endif " id="title_{{$language->prefix}}-tab" data-toggle="tab" href="#title_{{$language->prefix}}" role="tab" aria-controls="title_{{$language->prefix}}" aria-selected="true">{{$language->name}}</a>
								@endforeach
							</div>
						</nav>

						<div class="tab-content py-3 px-3 px-sm-0" id="nav-tabContent">
							@foreach(Config::get('app.languages') as $language)
							<div class="tab-pane fade show @if(Config::get('app.locale')==$language->prefix) active @endif" id="title_{{$language->prefix}}" role="tabpanel" aria-labelledby="title_{{$language->prefix}}-tab">
								<div class="form-group row">
									<label for="media_title_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('title')}} [{{$language->prefix}}]</label>
									<div class="col-sm-10">
										<input type="text" class="form-control" id="media_title_{{$language->prefix}}" name="media_title_{{$language->prefix}}" placeholder="{{__('Enter Image title')}} ... " />
									</div>
								</div>
								<div class="form-group row">
									<label for="media_alt_{{$language->prefix}}" class="col-sm-2 col-form-label">{{__('alt')}} [{{$language->prefix}}]</label>
									<div class="col-sm-10">
										<input type="text" class="form-control" id="media_alt_{{$language->prefix}}" name="media_alt_{{$language->prefix}}" placeholder="{{__('Enter Image alt')}} ... " />
									</div>
								</div>
							</div>
							@endforeach
						</div>

					</div>

					<div class="modal-footer">
						<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
						<button type="button" id="updateMedia" class="btn btn-primary"> <i class="fa fa-check"></i> Save changes</button>
					</div>

				</form>
			</div>
		</div>


        <!-- jQuery -->
        <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>

        <!-- Bootstrap 4 -->
        <script src="{{ asset("/plugins/bootstrap/js/bootstrap.bundle.min.js") }}"></script>

        <!-- AdminLTE App -->
        <script src="{{ asset("/plugins/toastr/toastr.min.js") }}"></script>

        <!-- AdminLTE App -->
        <script src="{{ asset("/plugins/select2/js/select2.full.min.js") }}"></script>

		<script src="https://cdn.jsdelivr.net/npm/chart.js@2.9.3/dist/Chart.min.js"></script>

        <script src="{{ asset("/plugins/summernote/summernote-bs4.min.js") }}"></script>

        <script src="{{ asset("/plugins/datatables/jquery.dataTables.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/dataTables.buttons.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.bootstrap4.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.colVis.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.html5.min.js") }}"></script>
        <script src="{{ asset("/plugins/datatables-buttons/js/buttons.print.min.js") }}"></script>


        <!-- AdminLTE App -->
        <script src="{{ asset("/plugins/adminlte/js/adminlte.min.js") }}"></script>

        <!-- Bootstrap 4 -->
        <script src="https://www.gstatic.com/firebasejs/7.15.0/firebase-app.js"></script>
        <script src="https://www.gstatic.com/firebasejs/7.15.0/firebase-analytics.js"></script>
        <script src="https://www.gstatic.com/firebasejs/7.15.0/firebase-messaging.js"></script>

		<!-- Afrodien App JS -->
		<script src="{{ asset("/plugins/afrodien/js/app.js") }}"></script>

        <!-- Bootstrap 4 -->
        <script src="{{ asset("/plugins/afrodien/js/dashboard.app.js") }}"></script>

    </body>

</html>
