@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->

                    <form class="card card-primary card-outline validate-form" data-system="{{$system->slug}}" @if(isset($record['id'])) data-type="edit" @else  data-type="new" @endif @isset($record['id']) data-id="{{$record['id']}}" @endisset id="form" action="@if(isset($record['id'])) {{ route('dashboard.virtual-system.edit', [ 'record_id' => $record['id'], 'page_slug' => $system->slug ]) }} @else {{route('dashboard.virtual-system.create', ['page_slug' => $system->slug ])}} @endif">
                        <div class="card-header">
                            <h3 class="card-title">@if(isset($record['id'])) {{__('Edit')}} @else {{__('New')}} @endif {{$title}}</h3>
                        </div>

                        <div class="card-body">
                            @foreach($system->fields as $Field)
                                {{VirtualSystem::getVirtualForm($system,$Field,$record)}}
                            @endforeach
                        </div>

                        <!-- /.card-body -->
                        <div class="card-footer text-right">
                            <a href="{{route('dashboard.virtual-system.index', ['page_slug' => $system->slug ] )}}" class="btn btn-sm btn-secondary"><i class="fa fa-arrow-left"></i> {{__('Back')}}</a>
                            <button type="button" id="submit_form" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Save')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                </div>
                <!-- /.card -->
            </div>
        </div>
    </section>
@endsection
