@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <div class="card card-primary card-outline">
                        <div class="card-header">
                            <h3 class="card-title">{{__('Search')}}</h3>
                        </div>


                        <div class="card-body">
                            <div class="row">
                                <div class="col-5 col-sm-3">
                                    <div class="nav flex-column nav-tabs h-100" id="vert-tabs-tab" role="tablist" aria-orientation="vertical">
                                        <a class="nav-link active" id="vert-tabs-profile-tab" data-toggle="pill" href="#vert-tabs-pages" role="tab" aria-controls="vert-tabs-pages" aria-selected="false">{{__('Pages')}}</a>
                                        <a class="nav-link" id="vert-tabs-messages-tab" data-toggle="pill" href="#vert-tabs-posts" role="tab" aria-controls="vert-tabs-posts" aria-selected="false">{{__('Posts')}}</a>
                                        <a class="nav-link" id="vert-tabs-settings-tab" data-toggle="pill" href="#vert-tabs-categories" role="tab" aria-controls="vert-tabs-categories" aria-selected="false">{{__('Categories')}}</a>
                                        <a class="nav-link" id="vert-tabs-settings-tab" data-toggle="pill" href="#vert-tabs-tags" role="tab" aria-controls="vert-tabs-tags" aria-selected="false">{{__('Tags')}}</a>
                                    </div>
                                </div>
                                <div class="col-7 col-sm-9">
                                    <div class="tab-content" id="vert-tabs-tabContent">
                                        <div class="tab-pane fade show active" id="vert-tabs-pages" role="tabpanel" aria-labelledby="vert-tabs-pages-tab">
                                            @forelse($pages as $row)
												@php
													$row->structure();
												@endphp
                                                <div class="attachment-block clearfix">
                                                    <img class="attachment-img" src="{{$row->featuredImage['src']}}" alt="Attachment Image">

                                                    <div class="attachment-pushed">
                                                        <h4 class="attachment-heading">
                                                            <a href="{{route('dashboard.virtual-system.edit', [ 'page_slug' => 'pages' , 'record_id' => $row->id ] )}}">{{$row->title}}</a>
                                                        </h4>

                                                        <div class="attachment-text">
                                                            {{$row->description}}
                                                        </div>
                                                    </div>
                                                </div>
                                            @empty
												{{__('Sorry, No data here.')}}
                                            @endforelse
                                        </div>
                                        <div class="tab-pane fade" id="vert-tabs-posts" role="tabpanel" aria-labelledby="vert-tabs-posts-tab">
                                            @forelse($posts as $row)
												@php
													$row->structure();
												@endphp
                                                <div class="attachment-block clearfix">
                                                    <img class="attachment-img" src="{{$row->featuredImage['src']}}" alt="{{$row->title}}">

                                                    <div class="attachment-pushed">
                                                        <h4 class="attachment-heading">
                                                            <a href="{{route('dashboard.virtual-system.edit', [ 'page_slug' => 'posts' , 'record_id' => $row->post_id ] )}}">{{$row->title}}</a>
                                                        </h4>

                                                        <div class="attachment-text">
                                                            {{$row->description}}
                                                        </div>
                                                    </div>
                                                </div>
                                            @empty
												{{__('Sorry, No data here.')}}
                                            @endforelse
                                        </div>
                                        <div class="tab-pane fade" id="vert-tabs-categories" role="tabpanel" aria-labelledby="vert-tabs-categories-tab">
                                            @forelse($categories as $row)
												@php
													$row->structure();
												@endphp
                                                <div class="attachment-block clearfix">
                                                    <img class="attachment-img" src="{{$row->featuredImage['src']}}" alt="Attachment Image">

                                                    <div class="attachment-pushed">
                                                        <h4 class="attachment-heading">
                                                            <a href="{{route('dashboard.virtual-system.edit', [ 'page_slug' => 'categories'  , 'record_id' => $row->category_id ] )}}">{{$row->title}}</a>
                                                        </h4>

                                                        <div class="attachment-text">
                                                            {{$row->description}}
                                                        </div>
                                                    </div>
                                                </div>
                                            @empty
												{{__('Sorry, No data here.')}}
                                            @endforelse
                                        </div>
                                        <div class="tab-pane fade" id="vert-tabs-tags" role="tabpanel" aria-labelledby="vert-tabs-settings-tags">
                                            @forelse($tags as $row)
												@php
													$row->structure();
												@endphp
                                                <div class="attachment-block clearfix">
                                                    <img class="attachment-img" src="{{$row->featuredImage['src']}}" alt="Attachment Image">

                                                    <div class="attachment-pushed">
                                                        <h4 class="attachment-heading">
                                                            <a href="{{route('dashboard.virtual-system.edit', [ 'page_slug' => 'tags' , 'record_id' => $row->tag_id ] )}}">{{$row->title}}</a>
                                                        </h4>

                                                        <div class="attachment-text">
                                                            {{$row->description}}
                                                        </div>
                                                    </div>
                                                </div>
                                            @empty
                                                {{__('Sorry, No data here.')}}
                                            @endforelse
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
@endsection
