@extends('dashboard.layout')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Default box -->
                    <form class="card card-primary card-outline" method="post" action="{{route('dashboard.support.tickets.store')}}" id="form" >

                        <div class="card-header">
                            <h3 class="card-title">{{__('Create Ticket')}}</h3>
                        </div>

                        <div class="card-body">

                            @csrf

							<div class="form-group row">
                                <label for="Title" class="col-sm-2 col-form-label">{{__('Title')}}</label>
                                <div class="col-sm-10">
                                    <input type="text" value="" class="form-control" id="Title" name="Title" placeholder="{{__('Enter Title')}} ... " />
                                </div>
                            </div>

							<div class="form-group row">
								<label for="job_title" class="col-sm-2 col-form-label">Status</label>
								<div class="col-sm-10">
									<select class="form-control select2" data-placeholder="Select Status" id="Status" name="Status" placeholder="Select Status">
										<option value="closed">closed</option>
										<option value="awaiting">awaiting reply</option>
										<option value="inprogress">inprogress</option>
									</select>
								</div>
							</div>

							<div class="form-group row">
								<label for="job_title" class="col-sm-2 col-form-label">User</label>
								<div class="col-sm-10">
									<select class="form-control select2" data-placeholder="Select User" id="User" name="User" placeholder="Select User">
										@foreach(App\User::all() as $user)
											<option value="{{$user->id}}">
												{{$user->name}}
											</option>
										@endforeach
									</select>
								</div>
							</div>

							<div class="form-group row">
                                <label for="Content" class="col-sm-2 col-form-label">Content</label>
                                <div class="col-sm-10">
                                    <textarea class="form-control summernote" id="Content" name="Content" placeholder="{{__('Enter Content')}} ... "></textarea>
                                </div>
                            </div>


							<div class="form-group row">
								<label for="job_title" class="col-sm-2 col-form-label">Department</label>
								<div class="col-sm-10">
									<select class="form-control select2" data-placeholder="Select Department" id="Department" name="Department" placeholder="Select Department">
										@foreach($departments as $department)
											<option value="{{$department->id}}">
												{{$department->name}}
											</option>
										@endforeach
									</select>
								</div>
							</div>


                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer">
							<button type="button" id="createTicket" class="btn btn-sm btn-success"><i class="fa fa-check"></i> {{__('Save')}}</button>
                        </div>
                        <!-- /.card-footer-->
                    </form>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
@endsection
